/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSnapshotAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSnapshotAttributeResponse extends EC2Response implements
        ToCopyableBuilder<DescribeSnapshotAttributeResponse.Builder, DescribeSnapshotAttributeResponse> {
    private final List<CreateVolumePermission> createVolumePermissions;

    private final List<ProductCode> productCodes;

    private final String snapshotId;

    private DescribeSnapshotAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.createVolumePermissions = builder.createVolumePermissions;
        this.productCodes = builder.productCodes;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * A list of permissions for creating volumes from the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of permissions for creating volumes from the snapshot.
     */
    public List<CreateVolumePermission> createVolumePermissions() {
        return createVolumePermissions;
    }

    /**
     * <p>
     * A list of product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The ID of the EBS snapshot.
     * </p>
     * 
     * @return The ID of the EBS snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createVolumePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotAttributeResponse)) {
            return false;
        }
        DescribeSnapshotAttributeResponse other = (DescribeSnapshotAttributeResponse) obj;
        return Objects.equals(createVolumePermissions(), other.createVolumePermissions())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotAttributeResponse").add("CreateVolumePermissions", createVolumePermissions())
                .add("ProductCodes", productCodes()).add("SnapshotId", snapshotId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateVolumePermissions":
            return Optional.of(clazz.cast(createVolumePermissions()));
        case "ProductCodes":
            return Optional.of(clazz.cast(productCodes()));
        case "SnapshotId":
            return Optional.of(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeSnapshotAttributeResponse> {
        /**
         * <p>
         * A list of permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        A list of permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions);

        /**
         * <p>
         * A list of permissions for creating volumes from the snapshot.
         * </p>
         * 
         * @param createVolumePermissions
         *        A list of permissions for creating volumes from the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The ID of the EBS snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<CreateVolumePermission> createVolumePermissions;

        private List<ProductCode> productCodes;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotAttributeResponse model) {
            createVolumePermissions(model.createVolumePermissions);
            productCodes(model.productCodes);
            snapshotId(model.snapshotId);
        }

        public final Collection<CreateVolumePermission.Builder> getCreateVolumePermissions() {
            return createVolumePermissions != null ? createVolumePermissions.stream().map(CreateVolumePermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createVolumePermissions(Collection<CreateVolumePermission> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copy(createVolumePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createVolumePermissions(CreateVolumePermission... createVolumePermissions) {
            createVolumePermissions(Arrays.asList(createVolumePermissions));
            return this;
        }

        public final void setCreateVolumePermissions(Collection<CreateVolumePermission.BuilderImpl> createVolumePermissions) {
            this.createVolumePermissions = CreateVolumePermissionListCopier.copyFromBuilder(createVolumePermissions);
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public DescribeSnapshotAttributeResponse build() {
            return new DescribeSnapshotAttributeResponse(this);
        }
    }
}
