/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVolumeStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumeStatusRequest extends EC2Request implements
        ToCopyableBuilder<DescribeVolumeStatusRequest.Builder, DescribeVolumeStatusRequest> {
    private final List<Filter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> volumeIds;

    private DescribeVolumeStatusRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.volumeIds = builder.volumeIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>action.description</code> - A description of the action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>action.event-id</code> - The event ID associated with the action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.description</code> - A description of the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.event-id</code> - The event ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
     * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
     * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-after</code> - The latest end time for the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-before</code> - The earliest start time for the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
     * <code>io-enabled</code> | <code>io-performance</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
     * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
     * <code>warning</code> | <code>insufficient-data</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>action.description</code> - A description of the action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>action.event-id</code> - The event ID associated with the action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.description</code> - A description of the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.event-id</code> - The event ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
     *         <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
     *         <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-after</code> - The latest end time for the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-before</code> - The earliest start time for the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
     *         <code>io-enabled</code> | <code>io-performance</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
     *         <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
     *         <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
     *         <code>warning</code> | <code>insufficient-data</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output. When this
     * parameter is used, the request only returns <code>MaxResults</code> results in a single page along with a
     * <code>NextToken</code> response element. The remaining results of the initial request can be seen by sending
     * another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000; if
     * <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this parameter is
     * not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot specify this parameter and the
     * volume IDs parameter in the same request.
     * </p>
     * 
     * @return The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output.
     *         When this parameter is used, the request only returns <code>MaxResults</code> results in a single page
     *         along with a <code>NextToken</code> response element. The remaining results of the initial request can be
     *         seen by sending another request with the returned <code>NextToken</code> value. This value can be between
     *         5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned.
     *         If this parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot
     *         specify this parameter and the volume IDs parameter in the same request.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When the
     * results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of
     * results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When
     *         the results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next
     *         page of results. This value is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * One or more volume IDs.
     * </p>
     * <p>
     * Default: Describes all your volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more volume IDs.</p>
     *         <p>
     *         Default: Describes all your volumes.
     */
    public List<String> volumeIds() {
        return volumeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusRequest)) {
            return false;
        }
        DescribeVolumeStatusRequest other = (DescribeVolumeStatusRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(volumeIds(), other.volumeIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVolumeStatusRequest").add("Filters", filters()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("VolumeIds", volumeIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "VolumeIds":
            return Optional.of(clazz.cast(volumeIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeVolumeStatusRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.description</code> - A description of the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.event-id</code> - The event ID associated with the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-id</code> - The event ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         *        <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         *        <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         *        <code>io-enabled</code> | <code>io-performance</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         *        <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         *        <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code>
         *        | <code>warning</code> | <code>insufficient-data</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.description</code> - A description of the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>action.event-id</code> - The event ID associated with the action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-id</code> - The event ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         * <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         * <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         * <code>io-enabled</code> | <code>io-performance</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         * <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         * <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code> |
         * <code>warning</code> | <code>insufficient-data</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>action.code</code> - The action code for the event (for example, <code>enable-volume-io</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.description</code> - A description of the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>action.event-id</code> - The event ID associated with the action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-id</code> - The event ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.event-type</code> - The event type (for <code>io-enabled</code>: <code>passed</code> |
         *        <code>failed</code>; for <code>io-performance</code>: <code>io-performance:degraded</code> |
         *        <code>io-performance:severely-degraded</code> | <code>io-performance:stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-name</code> - The cause for <code>volume-status.status</code> (
         *        <code>io-enabled</code> | <code>io-performance</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.details-status</code> - The status of <code>volume-status.details-name</code> (for
         *        <code>io-enabled</code>: <code>passed</code> | <code>failed</code>; for <code>io-performance</code>:
         *        <code>normal</code> | <code>degraded</code> | <code>severely-degraded</code> | <code>stalled</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>volume-status.status</code> - The status of the volume (<code>ok</code> | <code>impaired</code>
         *        | <code>warning</code> | <code>insufficient-data</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated output. When
         * this parameter is used, the request only returns <code>MaxResults</code> results in a single page along with
         * a <code>NextToken</code> response element. The remaining results of the initial request can be seen by
         * sending another request with the returned <code>NextToken</code> value. This value can be between 5 and 1000;
         * if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned. If this
         * parameter is not used, then <code>DescribeVolumeStatus</code> returns all results. You cannot specify this
         * parameter and the volume IDs parameter in the same request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of volume results returned by <code>DescribeVolumeStatus</code> in paginated
         *        output. When this parameter is used, the request only returns <code>MaxResults</code> results in a
         *        single page along with a <code>NextToken</code> response element. The remaining results of the initial
         *        request can be seen by sending another request with the returned <code>NextToken</code> value. This
         *        value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only
         *        1000 results are returned. If this parameter is not used, then <code>DescribeVolumeStatus</code>
         *        returns all results. You cannot specify this parameter and the volume IDs parameter in the same
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request. When the
         * results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the next page of
         * results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value to include in a future <code>DescribeVolumeStatus</code> request.
         *        When the results of the request exceed <code>MaxResults</code>, this value can be used to retrieve the
         *        next page of results. This value is <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * One or more volume IDs.
         * </p>
         * <p>
         * Default: Describes all your volumes.
         * </p>
         * 
         * @param volumeIds
         *        One or more volume IDs.</p>
         *        <p>
         *        Default: Describes all your volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(Collection<String> volumeIds);

        /**
         * <p>
         * One or more volume IDs.
         * </p>
         * <p>
         * Default: Describes all your volumes.
         * </p>
         * 
         * @param volumeIds
         *        One or more volume IDs.</p>
         *        <p>
         *        Default: Describes all your volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeIds(String... volumeIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private Integer maxResults;

        private String nextToken;

        private List<String> volumeIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusRequest model) {
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            volumeIds(model.volumeIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getVolumeIds() {
            return volumeIds;
        }

        @Override
        public final Builder volumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeIds(String... volumeIds) {
            volumeIds(Arrays.asList(volumeIds));
            return this;
        }

        public final void setVolumeIds(Collection<String> volumeIds) {
            this.volumeIds = VolumeIdStringListCopier.copy(volumeIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeVolumeStatusRequest build() {
            return new DescribeVolumeStatusRequest(this);
        }
    }
}
