/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DetachVolume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachVolumeRequest extends EC2Request implements
        ToCopyableBuilder<DetachVolumeRequest.Builder, DetachVolumeRequest> {
    private final String device;

    private final Boolean force;

    private final String instanceId;

    private final String volumeId;

    private DetachVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.device = builder.device;
        this.force = builder.force;
        this.instanceId = builder.instanceId;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * 
     * @return The device name.
     */
    public String device() {
        return device;
    }

    /**
     * <p>
     * Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
     * instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted file
     * system. Use this option only as a last resort to detach a volume from a failed instance. The instance won't have
     * an opportunity to flush file system caches or file system metadata. If you use this option, you must perform file
     * system check and repair procedures.
     * </p>
     * 
     * @return Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
     *         instance, unmounting the volume, and detaching normally). This option can lead to data loss or a
     *         corrupted file system. Use this option only as a last resort to detach a volume from a failed instance.
     *         The instance won't have an opportunity to flush file system caches or file system metadata. If you use
     *         this option, you must perform file system check and repair procedures.
     */
    public Boolean force() {
        return force;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ID of the volume.
     * </p>
     * 
     * @return The ID of the volume.
     */
    public String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachVolumeRequest)) {
            return false;
        }
        DetachVolumeRequest other = (DetachVolumeRequest) obj;
        return Objects.equals(device(), other.device()) && Objects.equals(force(), other.force())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(volumeId(), other.volumeId());
    }

    @Override
    public String toString() {
        return ToString.builder("DetachVolumeRequest").add("Device", device()).add("Force", force())
                .add("InstanceId", instanceId()).add("VolumeId", volumeId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Device":
            return Optional.of(clazz.cast(device()));
        case "Force":
            return Optional.of(clazz.cast(force()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DetachVolumeRequest> {
        /**
         * <p>
         * The device name.
         * </p>
         * 
         * @param device
         *        The device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into an
         * instance, unmounting the volume, and detaching normally). This option can lead to data loss or a corrupted
         * file system. Use this option only as a last resort to detach a volume from a failed instance. The instance
         * won't have an opportunity to flush file system caches or file system metadata. If you use this option, you
         * must perform file system check and repair procedures.
         * </p>
         * 
         * @param force
         *        Forces detachment if the previous detachment attempt did not occur cleanly (for example, logging into
         *        an instance, unmounting the volume, and detaching normally). This option can lead to data loss or a
         *        corrupted file system. Use this option only as a last resort to detach a volume from a failed
         *        instance. The instance won't have an opportunity to flush file system caches or file system metadata.
         *        If you use this option, you must perform file system check and repair procedures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ID of the volume.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String device;

        private Boolean force;

        private String instanceId;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachVolumeRequest model) {
            device(model.device);
            force(model.force);
            instanceId(model.instanceId);
            volumeId(model.volumeId);
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DetachVolumeRequest build() {
            return new DetachVolumeRequest(this);
        }
    }
}
