/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DisassociateRouteTable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DisassociateRouteTableRequest extends EC2Request implements
        ToCopyableBuilder<DisassociateRouteTableRequest.Builder, DisassociateRouteTableRequest> {
    private final String associationId;

    private DisassociateRouteTableRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
    }

    /**
     * <p>
     * The association ID representing the current association between the route table and subnet.
     * </p>
     * 
     * @return The association ID representing the current association between the route table and subnet.
     */
    public String associationId() {
        return associationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateRouteTableRequest)) {
            return false;
        }
        DisassociateRouteTableRequest other = (DisassociateRouteTableRequest) obj;
        return Objects.equals(associationId(), other.associationId());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateRouteTableRequest").add("AssociationId", associationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DisassociateRouteTableRequest> {
        /**
         * <p>
         * The association ID representing the current association between the route table and subnet.
         * </p>
         * 
         * @param associationId
         *        The association ID representing the current association between the route table and subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String associationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateRouteTableRequest model) {
            associationId(model.associationId);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DisassociateRouteTableRequest build() {
            return new DisassociateRouteTableRequest(this);
        }
    }
}
