/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the association between an instance and an Elastic GPU.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticGpuAssociation implements ToCopyableBuilder<ElasticGpuAssociation.Builder, ElasticGpuAssociation> {
    private final String elasticGpuId;

    private final String elasticGpuAssociationId;

    private final String elasticGpuAssociationState;

    private final String elasticGpuAssociationTime;

    private ElasticGpuAssociation(BuilderImpl builder) {
        this.elasticGpuId = builder.elasticGpuId;
        this.elasticGpuAssociationId = builder.elasticGpuAssociationId;
        this.elasticGpuAssociationState = builder.elasticGpuAssociationState;
        this.elasticGpuAssociationTime = builder.elasticGpuAssociationTime;
    }

    /**
     * <p>
     * The ID of the Elastic GPU.
     * </p>
     * 
     * @return The ID of the Elastic GPU.
     */
    public String elasticGpuId() {
        return elasticGpuId;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public String elasticGpuAssociationId() {
        return elasticGpuAssociationId;
    }

    /**
     * <p>
     * The state of the association between the instance and the Elastic GPU.
     * </p>
     * 
     * @return The state of the association between the instance and the Elastic GPU.
     */
    public String elasticGpuAssociationState() {
        return elasticGpuAssociationState;
    }

    /**
     * <p>
     * The time the Elastic GPU was associated with the instance.
     * </p>
     * 
     * @return The time the Elastic GPU was associated with the instance.
     */
    public String elasticGpuAssociationTime() {
        return elasticGpuAssociationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuId());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociationState());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuAssociationTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticGpuAssociation)) {
            return false;
        }
        ElasticGpuAssociation other = (ElasticGpuAssociation) obj;
        return Objects.equals(elasticGpuId(), other.elasticGpuId())
                && Objects.equals(elasticGpuAssociationId(), other.elasticGpuAssociationId())
                && Objects.equals(elasticGpuAssociationState(), other.elasticGpuAssociationState())
                && Objects.equals(elasticGpuAssociationTime(), other.elasticGpuAssociationTime());
    }

    @Override
    public String toString() {
        return ToString.builder("ElasticGpuAssociation").add("ElasticGpuId", elasticGpuId())
                .add("ElasticGpuAssociationId", elasticGpuAssociationId())
                .add("ElasticGpuAssociationState", elasticGpuAssociationState())
                .add("ElasticGpuAssociationTime", elasticGpuAssociationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuId":
            return Optional.of(clazz.cast(elasticGpuId()));
        case "ElasticGpuAssociationId":
            return Optional.of(clazz.cast(elasticGpuAssociationId()));
        case "ElasticGpuAssociationState":
            return Optional.of(clazz.cast(elasticGpuAssociationState()));
        case "ElasticGpuAssociationTime":
            return Optional.of(clazz.cast(elasticGpuAssociationTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticGpuAssociation> {
        /**
         * <p>
         * The ID of the Elastic GPU.
         * </p>
         * 
         * @param elasticGpuId
         *        The ID of the Elastic GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuId(String elasticGpuId);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param elasticGpuAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociationId(String elasticGpuAssociationId);

        /**
         * <p>
         * The state of the association between the instance and the Elastic GPU.
         * </p>
         * 
         * @param elasticGpuAssociationState
         *        The state of the association between the instance and the Elastic GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociationState(String elasticGpuAssociationState);

        /**
         * <p>
         * The time the Elastic GPU was associated with the instance.
         * </p>
         * 
         * @param elasticGpuAssociationTime
         *        The time the Elastic GPU was associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuAssociationTime(String elasticGpuAssociationTime);
    }

    static final class BuilderImpl implements Builder {
        private String elasticGpuId;

        private String elasticGpuAssociationId;

        private String elasticGpuAssociationState;

        private String elasticGpuAssociationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticGpuAssociation model) {
            elasticGpuId(model.elasticGpuId);
            elasticGpuAssociationId(model.elasticGpuAssociationId);
            elasticGpuAssociationState(model.elasticGpuAssociationState);
            elasticGpuAssociationTime(model.elasticGpuAssociationTime);
        }

        public final String getElasticGpuId() {
            return elasticGpuId;
        }

        @Override
        public final Builder elasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
            return this;
        }

        public final void setElasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
        }

        public final String getElasticGpuAssociationId() {
            return elasticGpuAssociationId;
        }

        @Override
        public final Builder elasticGpuAssociationId(String elasticGpuAssociationId) {
            this.elasticGpuAssociationId = elasticGpuAssociationId;
            return this;
        }

        public final void setElasticGpuAssociationId(String elasticGpuAssociationId) {
            this.elasticGpuAssociationId = elasticGpuAssociationId;
        }

        public final String getElasticGpuAssociationState() {
            return elasticGpuAssociationState;
        }

        @Override
        public final Builder elasticGpuAssociationState(String elasticGpuAssociationState) {
            this.elasticGpuAssociationState = elasticGpuAssociationState;
            return this;
        }

        public final void setElasticGpuAssociationState(String elasticGpuAssociationState) {
            this.elasticGpuAssociationState = elasticGpuAssociationState;
        }

        public final String getElasticGpuAssociationTime() {
            return elasticGpuAssociationTime;
        }

        @Override
        public final Builder elasticGpuAssociationTime(String elasticGpuAssociationTime) {
            this.elasticGpuAssociationTime = elasticGpuAssociationTime;
            return this;
        }

        public final void setElasticGpuAssociationTime(String elasticGpuAssociationTime) {
            this.elasticGpuAssociationTime = elasticGpuAssociationTime;
        }

        @Override
        public ElasticGpuAssociation build() {
            return new ElasticGpuAssociation(this);
        }
    }
}
