/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHostReservationPurchasePreviewRequest extends EC2Request implements
        ToCopyableBuilder<GetHostReservationPurchasePreviewRequest.Builder, GetHostReservationPurchasePreviewRequest> {
    private final List<String> hostIdSet;

    private final String offeringId;

    private GetHostReservationPurchasePreviewRequest(BuilderImpl builder) {
        super(builder);
        this.hostIdSet = builder.hostIdSet;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * The ID/s of the Dedicated Host/s that the reservation will be associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The ID/s of the Dedicated Host/s that the reservation will be associated with.
     */
    public List<String> hostIdSet() {
        return hostIdSet;
    }

    /**
     * <p>
     * The offering ID of the reservation.
     * </p>
     * 
     * @return The offering ID of the reservation.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostIdSet());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewRequest)) {
            return false;
        }
        GetHostReservationPurchasePreviewRequest other = (GetHostReservationPurchasePreviewRequest) obj;
        return Objects.equals(hostIdSet(), other.hostIdSet()) && Objects.equals(offeringId(), other.offeringId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHostReservationPurchasePreviewRequest").add("HostIdSet", hostIdSet())
                .add("OfferingId", offeringId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostIdSet":
            return Optional.of(clazz.cast(hostIdSet()));
        case "OfferingId":
            return Optional.of(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, GetHostReservationPurchasePreviewRequest> {
        /**
         * <p>
         * The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * </p>
         * 
         * @param hostIdSet
         *        The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(Collection<String> hostIdSet);

        /**
         * <p>
         * The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * </p>
         * 
         * @param hostIdSet
         *        The ID/s of the Dedicated Host/s that the reservation will be associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostIdSet(String... hostIdSet);

        /**
         * <p>
         * The offering ID of the reservation.
         * </p>
         * 
         * @param offeringId
         *        The offering ID of the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> hostIdSet;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewRequest model) {
            hostIdSet(model.hostIdSet);
            offeringId(model.offeringId);
        }

        public final Collection<String> getHostIdSet() {
            return hostIdSet;
        }

        @Override
        public final Builder hostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostIdSet(String... hostIdSet) {
            hostIdSet(Arrays.asList(hostIdSet));
            return this;
        }

        public final void setHostIdSet(Collection<String> hostIdSet) {
            this.hostIdSet = RequestHostIdSetCopier.copy(hostIdSet);
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetHostReservationPurchasePreviewRequest build() {
            return new GetHostReservationPurchasePreviewRequest(this);
        }
    }
}
