/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the disk container object for an import image task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImageDiskContainer implements ToCopyableBuilder<ImageDiskContainer.Builder, ImageDiskContainer> {
    private final String description;

    private final String deviceName;

    private final String format;

    private final String snapshotId;

    private final String url;

    private final UserBucket userBucket;

    private ImageDiskContainer(BuilderImpl builder) {
        this.description = builder.description;
        this.deviceName = builder.deviceName;
        this.format = builder.format;
        this.snapshotId = builder.snapshotId;
        this.url = builder.url;
        this.userBucket = builder.userBucket;
    }

    /**
     * <p>
     * The description of the disk image.
     * </p>
     * 
     * @return The description of the disk image.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The block device mapping for the disk.
     * </p>
     * 
     * @return The block device mapping for the disk.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The format of the disk image being imported.
     * </p>
     * <p>
     * Valid values: <code>RAW</code> | <code>VHD</code> | <code>VMDK</code> | <code>OVA</code>
     * </p>
     * 
     * @return The format of the disk image being imported.</p>
     *         <p>
     *         Valid values: <code>RAW</code> | <code>VHD</code> | <code>VMDK</code> | <code>OVA</code>
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * The ID of the EBS snapshot to be used for importing the snapshot.
     * </p>
     * 
     * @return The ID of the EBS snapshot to be used for importing the snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an
     * Amazon S3 URL (s3://..)
     * </p>
     * 
     * @return The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..)
     *         or an Amazon S3 URL (s3://..)
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The S3 bucket for the disk image.
     * </p>
     * 
     * @return The S3 bucket for the disk image.
     */
    public UserBucket userBucket() {
        return userBucket;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(userBucket());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDiskContainer)) {
            return false;
        }
        ImageDiskContainer other = (ImageDiskContainer) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(format(), other.format()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(url(), other.url()) && Objects.equals(userBucket(), other.userBucket());
    }

    @Override
    public String toString() {
        return ToString.builder("ImageDiskContainer").add("Description", description()).add("DeviceName", deviceName())
                .add("Format", format()).add("SnapshotId", snapshotId()).add("Url", url()).add("UserBucket", userBucket())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        case "Format":
            return Optional.of(clazz.cast(format()));
        case "SnapshotId":
            return Optional.of(clazz.cast(snapshotId()));
        case "Url":
            return Optional.of(clazz.cast(url()));
        case "UserBucket":
            return Optional.of(clazz.cast(userBucket()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImageDiskContainer> {
        /**
         * <p>
         * The description of the disk image.
         * </p>
         * 
         * @param description
         *        The description of the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The block device mapping for the disk.
         * </p>
         * 
         * @param deviceName
         *        The block device mapping for the disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The format of the disk image being imported.
         * </p>
         * <p>
         * Valid values: <code>RAW</code> | <code>VHD</code> | <code>VMDK</code> | <code>OVA</code>
         * </p>
         * 
         * @param format
         *        The format of the disk image being imported.</p>
         *        <p>
         *        Valid values: <code>RAW</code> | <code>VHD</code> | <code>VMDK</code> | <code>OVA</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The ID of the EBS snapshot to be used for importing the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the EBS snapshot to be used for importing the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or
         * an Amazon S3 URL (s3://..)
         * </p>
         * 
         * @param url
         *        The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL
         *        (https://..) or an Amazon S3 URL (s3://..)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * 
         * @param userBucket
         *        The S3 bucket for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userBucket(UserBucket userBucket);

        /**
         * <p>
         * The S3 bucket for the disk image.
         * </p>
         * This is a convenience that creates an instance of the {@link UserBucket.Builder} avoiding the need to create
         * one manually via {@link UserBucket#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserBucket.Builder#build()} is called immediately and its result
         * is passed to {@link #userBucket(UserBucket)}.
         * 
         * @param userBucket
         *        a consumer that will call methods on {@link UserBucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userBucket(UserBucket)
         */
        default Builder userBucket(Consumer<UserBucket.Builder> userBucket) {
            return userBucket(UserBucket.builder().apply(userBucket).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String deviceName;

        private String format;

        private String snapshotId;

        private String url;

        private UserBucket userBucket;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDiskContainer model) {
            description(model.description);
            deviceName(model.deviceName);
            format(model.format);
            snapshotId(model.snapshotId);
            url(model.url);
            userBucket(model.userBucket);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final UserBucket.Builder getUserBucket() {
            return userBucket != null ? userBucket.toBuilder() : null;
        }

        @Override
        public final Builder userBucket(UserBucket userBucket) {
            this.userBucket = userBucket;
            return this;
        }

        public final void setUserBucket(UserBucket.BuilderImpl userBucket) {
            this.userBucket = userBucket != null ? userBucket.build() : null;
        }

        @Override
        public ImageDiskContainer build() {
            return new ImageDiskContainer(this);
        }
    }
}
