/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance to export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceExportDetails implements ToCopyableBuilder<InstanceExportDetails.Builder, InstanceExportDetails> {
    private final String instanceId;

    private final String targetEnvironment;

    private InstanceExportDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    /**
     * <p>
     * The ID of the resource being exported.
     * </p>
     * 
     * @return The ID of the resource being exported.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The target virtualization environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetEnvironment}
     * will return {@link ExportEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetEnvironmentString}.
     * </p>
     * 
     * @return The target virtualization environment.
     * @see ExportEnvironment
     */
    public ExportEnvironment targetEnvironment() {
        return ExportEnvironment.fromValue(targetEnvironment);
    }

    /**
     * <p>
     * The target virtualization environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetEnvironment}
     * will return {@link ExportEnvironment#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetEnvironmentString}.
     * </p>
     * 
     * @return The target virtualization environment.
     * @see ExportEnvironment
     */
    public String targetEnvironmentString() {
        return targetEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(targetEnvironmentString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceExportDetails)) {
            return false;
        }
        InstanceExportDetails other = (InstanceExportDetails) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(targetEnvironmentString(), other.targetEnvironmentString());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceExportDetails").add("InstanceId", instanceId())
                .add("TargetEnvironment", targetEnvironmentString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "TargetEnvironment":
            return Optional.of(clazz.cast(targetEnvironmentString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceExportDetails> {
        /**
         * <p>
         * The ID of the resource being exported.
         * </p>
         * 
         * @param instanceId
         *        The ID of the resource being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(String targetEnvironment);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(ExportEnvironment targetEnvironment);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceExportDetails model) {
            instanceId(model.instanceId);
            targetEnvironment(model.targetEnvironment);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTargetEnvironment() {
            return targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
            return this;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        @Override
        public InstanceExportDetails build() {
            return new InstanceExportDetails(this);
        }
    }
}
