/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a key pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyPair implements ToCopyableBuilder<KeyPair.Builder, KeyPair> {
    private final String keyFingerprint;

    private final String keyMaterial;

    private final String keyName;

    private KeyPair(BuilderImpl builder) {
        this.keyFingerprint = builder.keyFingerprint;
        this.keyMaterial = builder.keyMaterial;
        this.keyName = builder.keyName;
    }

    /**
     * <p>
     * The SHA-1 digest of the DER encoded private key.
     * </p>
     * 
     * @return The SHA-1 digest of the DER encoded private key.
     */
    public String keyFingerprint() {
        return keyFingerprint;
    }

    /**
     * <p>
     * An unencrypted PEM encoded RSA private key.
     * </p>
     * 
     * @return An unencrypted PEM encoded RSA private key.
     */
    public String keyMaterial() {
        return keyMaterial;
    }

    /**
     * <p>
     * The name of the key pair.
     * </p>
     * 
     * @return The name of the key pair.
     */
    public String keyName() {
        return keyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(keyMaterial());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair) obj;
        return Objects.equals(keyFingerprint(), other.keyFingerprint()) && Objects.equals(keyMaterial(), other.keyMaterial())
                && Objects.equals(keyName(), other.keyName());
    }

    @Override
    public String toString() {
        return ToString.builder("KeyPair").add("KeyFingerprint", keyFingerprint()).add("KeyMaterial", keyMaterial())
                .add("KeyName", keyName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyFingerprint":
            return Optional.of(clazz.cast(keyFingerprint()));
        case "KeyMaterial":
            return Optional.of(clazz.cast(keyMaterial()));
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, KeyPair> {
        /**
         * <p>
         * The SHA-1 digest of the DER encoded private key.
         * </p>
         * 
         * @param keyFingerprint
         *        The SHA-1 digest of the DER encoded private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFingerprint(String keyFingerprint);

        /**
         * <p>
         * An unencrypted PEM encoded RSA private key.
         * </p>
         * 
         * @param keyMaterial
         *        An unencrypted PEM encoded RSA private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyMaterial(String keyMaterial);

        /**
         * <p>
         * The name of the key pair.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);
    }

    static final class BuilderImpl implements Builder {
        private String keyFingerprint;

        private String keyMaterial;

        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            keyFingerprint(model.keyFingerprint);
            keyMaterial(model.keyMaterial);
            keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyMaterial() {
            return keyMaterial;
        }

        @Override
        public final Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public final void setKeyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public KeyPair build() {
            return new KeyPair(this);
        }
    }
}
