/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifyVpcEndpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcEndpointRequest extends EC2Request implements
        ToCopyableBuilder<ModifyVpcEndpointRequest.Builder, ModifyVpcEndpointRequest> {
    private final String vpcEndpointId;

    private final Boolean resetPolicy;

    private final String policyDocument;

    private final List<String> addRouteTableIds;

    private final List<String> removeRouteTableIds;

    private final List<String> addSubnetIds;

    private final List<String> removeSubnetIds;

    private final List<String> addSecurityGroupIds;

    private final List<String> removeSecurityGroupIds;

    private final Boolean privateDnsEnabled;

    private ModifyVpcEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointId = builder.vpcEndpointId;
        this.resetPolicy = builder.resetPolicy;
        this.policyDocument = builder.policyDocument;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
        this.addSubnetIds = builder.addSubnetIds;
        this.removeSubnetIds = builder.removeSubnetIds;
        this.addSecurityGroupIds = builder.addSecurityGroupIds;
        this.removeSecurityGroupIds = builder.removeSecurityGroupIds;
        this.privateDnsEnabled = builder.privateDnsEnabled;
    }

    /**
     * <p>
     * The ID of the endpoint.
     * </p>
     * 
     * @return The ID of the endpoint.
     */
    public String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default
     * policy allows full access to the service.
     * </p>
     * 
     * @return (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The
     *         default policy allows full access to the service.
     */
    public Boolean resetPolicy() {
        return resetPolicy;
    }

    /**
     * <p>
     * (Gateway endpoint) A policy document to attach to the endpoint. The policy must be in valid JSON format.
     * </p>
     * 
     * @return (Gateway endpoint) A policy document to attach to the endpoint. The policy must be in valid JSON format.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
     */
    public List<String> addRouteTableIds() {
        return addRouteTableIds;
    }

    /**
     * <p>
     * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
     */
    public List<String> removeRouteTableIds() {
        return removeRouteTableIds;
    }

    /**
     * <p>
     * (Interface endpoint) One or more subnet IDs in which to serve the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) One or more subnet IDs in which to serve the endpoint.
     */
    public List<String> addSubnetIds() {
        return addSubnetIds;
    }

    /**
     * <p>
     * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
     */
    public List<String> removeSubnetIds() {
        return removeSubnetIds;
    }

    /**
     * <p>
     * (Interface endpoint) One or more security group IDs to associate with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) One or more security group IDs to associate with the network interface.
     */
    public List<String> addSecurityGroupIds() {
        return addSecurityGroupIds;
    }

    /**
     * <p>
     * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Interface endpoint) One or more security group IDs to disassociate from the network interface.
     */
    public List<String> removeSecurityGroupIds() {
        return removeSecurityGroupIds;
    }

    /**
     * <p>
     * (Interface endpoint) Indicate whether a private hosted zone is associated with the VPC.
     * </p>
     * 
     * @return (Interface endpoint) Indicate whether a private hosted zone is associated with the VPC.
     */
    public Boolean privateDnsEnabled() {
        return privateDnsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(resetPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(addRouteTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(removeRouteTableIds());
        hashCode = 31 * hashCode + Objects.hashCode(addSubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(removeSubnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(addSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(removeSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointRequest)) {
            return false;
        }
        ModifyVpcEndpointRequest other = (ModifyVpcEndpointRequest) obj;
        return Objects.equals(vpcEndpointId(), other.vpcEndpointId()) && Objects.equals(resetPolicy(), other.resetPolicy())
                && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(addRouteTableIds(), other.addRouteTableIds())
                && Objects.equals(removeRouteTableIds(), other.removeRouteTableIds())
                && Objects.equals(addSubnetIds(), other.addSubnetIds())
                && Objects.equals(removeSubnetIds(), other.removeSubnetIds())
                && Objects.equals(addSecurityGroupIds(), other.addSecurityGroupIds())
                && Objects.equals(removeSecurityGroupIds(), other.removeSecurityGroupIds())
                && Objects.equals(privateDnsEnabled(), other.privateDnsEnabled());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyVpcEndpointRequest").add("VpcEndpointId", vpcEndpointId())
                .add("ResetPolicy", resetPolicy()).add("PolicyDocument", policyDocument())
                .add("AddRouteTableIds", addRouteTableIds()).add("RemoveRouteTableIds", removeRouteTableIds())
                .add("AddSubnetIds", addSubnetIds()).add("RemoveSubnetIds", removeSubnetIds())
                .add("AddSecurityGroupIds", addSecurityGroupIds()).add("RemoveSecurityGroupIds", removeSecurityGroupIds())
                .add("PrivateDnsEnabled", privateDnsEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointId":
            return Optional.of(clazz.cast(vpcEndpointId()));
        case "ResetPolicy":
            return Optional.of(clazz.cast(resetPolicy()));
        case "PolicyDocument":
            return Optional.of(clazz.cast(policyDocument()));
        case "AddRouteTableIds":
            return Optional.of(clazz.cast(addRouteTableIds()));
        case "RemoveRouteTableIds":
            return Optional.of(clazz.cast(removeRouteTableIds()));
        case "AddSubnetIds":
            return Optional.of(clazz.cast(addSubnetIds()));
        case "RemoveSubnetIds":
            return Optional.of(clazz.cast(removeSubnetIds()));
        case "AddSecurityGroupIds":
            return Optional.of(clazz.cast(addSecurityGroupIds()));
        case "RemoveSecurityGroupIds":
            return Optional.of(clazz.cast(removeSecurityGroupIds()));
        case "PrivateDnsEnabled":
            return Optional.of(clazz.cast(privateDnsEnabled()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifyVpcEndpointRequest> {
        /**
         * <p>
         * The ID of the endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The default
         * policy allows full access to the service.
         * </p>
         * 
         * @param resetPolicy
         *        (Gateway endpoint) Specify <code>true</code> to reset the policy document to the default policy. The
         *        default policy allows full access to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resetPolicy(Boolean resetPolicy);

        /**
         * <p>
         * (Gateway endpoint) A policy document to attach to the endpoint. The policy must be in valid JSON format.
         * </p>
         * 
         * @param policyDocument
         *        (Gateway endpoint) A policy document to attach to the endpoint. The policy must be in valid JSON
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(Collection<String> addRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(String... addRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(Collection<String> removeRouteTableIds);

        /**
         * <p>
         * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(String... removeRouteTableIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnet IDs in which to serve the endpoint.
         * </p>
         * 
         * @param addSubnetIds
         *        (Interface endpoint) One or more subnet IDs in which to serve the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(Collection<String> addSubnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnet IDs in which to serve the endpoint.
         * </p>
         * 
         * @param addSubnetIds
         *        (Interface endpoint) One or more subnet IDs in which to serve the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSubnetIds(String... addSubnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(Collection<String> removeSubnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * </p>
         * 
         * @param removeSubnetIds
         *        (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSubnetIds(String... removeSubnetIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to associate with the network interface.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to associate with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to associate with the network interface.
         * </p>
         * 
         * @param addSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to associate with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addSecurityGroupIds(String... addSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * </p>
         * 
         * @param removeSecurityGroupIds
         *        (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeSecurityGroupIds(String... removeSecurityGroupIds);

        /**
         * <p>
         * (Interface endpoint) Indicate whether a private hosted zone is associated with the VPC.
         * </p>
         * 
         * @param privateDnsEnabled
         *        (Interface endpoint) Indicate whether a private hosted zone is associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEnabled(Boolean privateDnsEnabled);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String vpcEndpointId;

        private Boolean resetPolicy;

        private String policyDocument;

        private List<String> addRouteTableIds;

        private List<String> removeRouteTableIds;

        private List<String> addSubnetIds;

        private List<String> removeSubnetIds;

        private List<String> addSecurityGroupIds;

        private List<String> removeSecurityGroupIds;

        private Boolean privateDnsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointRequest model) {
            vpcEndpointId(model.vpcEndpointId);
            resetPolicy(model.resetPolicy);
            policyDocument(model.policyDocument);
            addRouteTableIds(model.addRouteTableIds);
            removeRouteTableIds(model.removeRouteTableIds);
            addSubnetIds(model.addSubnetIds);
            removeSubnetIds(model.removeSubnetIds);
            addSecurityGroupIds(model.addSecurityGroupIds);
            removeSecurityGroupIds(model.removeSecurityGroupIds);
            privateDnsEnabled(model.privateDnsEnabled);
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        public final Boolean getResetPolicy() {
            return resetPolicy;
        }

        @Override
        public final Builder resetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
            return this;
        }

        public final void setResetPolicy(Boolean resetPolicy) {
            this.resetPolicy = resetPolicy;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final Collection<String> getAddRouteTableIds() {
            return addRouteTableIds;
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String... addRouteTableIds) {
            addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = ValueStringListCopier.copy(addRouteTableIds);
        }

        public final Collection<String> getRemoveRouteTableIds() {
            return removeRouteTableIds;
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String... removeRouteTableIds) {
            removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = ValueStringListCopier.copy(removeRouteTableIds);
        }

        public final Collection<String> getAddSubnetIds() {
            return addSubnetIds;
        }

        @Override
        public final Builder addSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = ValueStringListCopier.copy(addSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSubnetIds(String... addSubnetIds) {
            addSubnetIds(Arrays.asList(addSubnetIds));
            return this;
        }

        public final void setAddSubnetIds(Collection<String> addSubnetIds) {
            this.addSubnetIds = ValueStringListCopier.copy(addSubnetIds);
        }

        public final Collection<String> getRemoveSubnetIds() {
            return removeSubnetIds;
        }

        @Override
        public final Builder removeSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = ValueStringListCopier.copy(removeSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSubnetIds(String... removeSubnetIds) {
            removeSubnetIds(Arrays.asList(removeSubnetIds));
            return this;
        }

        public final void setRemoveSubnetIds(Collection<String> removeSubnetIds) {
            this.removeSubnetIds = ValueStringListCopier.copy(removeSubnetIds);
        }

        public final Collection<String> getAddSecurityGroupIds() {
            return addSecurityGroupIds;
        }

        @Override
        public final Builder addSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = ValueStringListCopier.copy(addSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addSecurityGroupIds(String... addSecurityGroupIds) {
            addSecurityGroupIds(Arrays.asList(addSecurityGroupIds));
            return this;
        }

        public final void setAddSecurityGroupIds(Collection<String> addSecurityGroupIds) {
            this.addSecurityGroupIds = ValueStringListCopier.copy(addSecurityGroupIds);
        }

        public final Collection<String> getRemoveSecurityGroupIds() {
            return removeSecurityGroupIds;
        }

        @Override
        public final Builder removeSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = ValueStringListCopier.copy(removeSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeSecurityGroupIds(String... removeSecurityGroupIds) {
            removeSecurityGroupIds(Arrays.asList(removeSecurityGroupIds));
            return this;
        }

        public final void setRemoveSecurityGroupIds(Collection<String> removeSecurityGroupIds) {
            this.removeSecurityGroupIds = ValueStringListCopier.copy(removeSecurityGroupIds);
        }

        public final Boolean getPrivateDnsEnabled() {
            return privateDnsEnabled;
        }

        @Override
        public final Builder privateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
            return this;
        }

        public final void setPrivateDnsEnabled(Boolean privateDnsEnabled) {
            this.privateDnsEnabled = privateDnsEnabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointRequest build() {
            return new ModifyVpcEndpointRequest(this);
        }
    }
}
