/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a network ACL and a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkAclAssociation implements ToCopyableBuilder<NetworkAclAssociation.Builder, NetworkAclAssociation> {
    private final String networkAclAssociationId;

    private final String networkAclId;

    private final String subnetId;

    private NetworkAclAssociation(BuilderImpl builder) {
        this.networkAclAssociationId = builder.networkAclAssociationId;
        this.networkAclId = builder.networkAclId;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * The ID of the association between a network ACL and a subnet.
     * </p>
     * 
     * @return The ID of the association between a network ACL and a subnet.
     */
    public String networkAclAssociationId() {
        return networkAclAssociationId;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAclAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclAssociation)) {
            return false;
        }
        NetworkAclAssociation other = (NetworkAclAssociation) obj;
        return Objects.equals(networkAclAssociationId(), other.networkAclAssociationId())
                && Objects.equals(networkAclId(), other.networkAclId()) && Objects.equals(subnetId(), other.subnetId());
    }

    @Override
    public String toString() {
        return ToString.builder("NetworkAclAssociation").add("NetworkAclAssociationId", networkAclAssociationId())
                .add("NetworkAclId", networkAclId()).add("SubnetId", subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkAclAssociationId":
            return Optional.of(clazz.cast(networkAclAssociationId()));
        case "NetworkAclId":
            return Optional.of(clazz.cast(networkAclId()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkAclAssociation> {
        /**
         * <p>
         * The ID of the association between a network ACL and a subnet.
         * </p>
         * 
         * @param networkAclAssociationId
         *        The ID of the association between a network ACL and a subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclAssociationId(String networkAclAssociationId);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private String networkAclAssociationId;

        private String networkAclId;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclAssociation model) {
            networkAclAssociationId(model.networkAclAssociationId);
            networkAclId(model.networkAclId);
            subnetId(model.subnetId);
        }

        public final String getNetworkAclAssociationId() {
            return networkAclAssociationId;
        }

        @Override
        public final Builder networkAclAssociationId(String networkAclAssociationId) {
            this.networkAclAssociationId = networkAclAssociationId;
            return this;
        }

        public final void setNetworkAclAssociationId(String networkAclAssociationId) {
            this.networkAclAssociationId = networkAclAssociationId;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public NetworkAclAssociation build() {
            return new NetworkAclAssociation(this);
        }
    }
}
