/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stale security group (a security group that contains stale rules).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StaleSecurityGroup implements ToCopyableBuilder<StaleSecurityGroup.Builder, StaleSecurityGroup> {
    private final String description;

    private final String groupId;

    private final String groupName;

    private final List<StaleIpPermission> staleIpPermissions;

    private final List<StaleIpPermission> staleIpPermissionsEgress;

    private final String vpcId;

    private StaleSecurityGroup(BuilderImpl builder) {
        this.description = builder.description;
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.staleIpPermissions = builder.staleIpPermissions;
        this.staleIpPermissionsEgress = builder.staleIpPermissionsEgress;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The description of the security group.
     * </p>
     * 
     * @return The description of the security group.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the security group.
     * </p>
     * 
     * @return The ID of the security group.
     */
    public String groupId() {
        return groupId;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * Information about the stale inbound rules in the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the stale inbound rules in the security group.
     */
    public List<StaleIpPermission> staleIpPermissions() {
        return staleIpPermissions;
    }

    /**
     * <p>
     * Information about the stale outbound rules in the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the stale outbound rules in the security group.
     */
    public List<StaleIpPermission> staleIpPermissionsEgress() {
        return staleIpPermissionsEgress;
    }

    /**
     * <p>
     * The ID of the VPC for the security group.
     * </p>
     * 
     * @return The ID of the VPC for the security group.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(staleIpPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(staleIpPermissionsEgress());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleSecurityGroup)) {
            return false;
        }
        StaleSecurityGroup other = (StaleSecurityGroup) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(groupId(), other.groupId())
                && Objects.equals(groupName(), other.groupName())
                && Objects.equals(staleIpPermissions(), other.staleIpPermissions())
                && Objects.equals(staleIpPermissionsEgress(), other.staleIpPermissionsEgress())
                && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("StaleSecurityGroup").add("Description", description()).add("GroupId", groupId())
                .add("GroupName", groupName()).add("StaleIpPermissions", staleIpPermissions())
                .add("StaleIpPermissionsEgress", staleIpPermissionsEgress()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "GroupId":
            return Optional.of(clazz.cast(groupId()));
        case "GroupName":
            return Optional.of(clazz.cast(groupName()));
        case "StaleIpPermissions":
            return Optional.of(clazz.cast(staleIpPermissions()));
        case "StaleIpPermissionsEgress":
            return Optional.of(clazz.cast(staleIpPermissionsEgress()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, StaleSecurityGroup> {
        /**
         * <p>
         * The description of the security group.
         * </p>
         * 
         * @param description
         *        The description of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the security group.
         * </p>
         * 
         * @param groupId
         *        The ID of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Information about the stale inbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissions
         *        Information about the stale inbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissions(Collection<StaleIpPermission> staleIpPermissions);

        /**
         * <p>
         * Information about the stale inbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissions
         *        Information about the stale inbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissions(StaleIpPermission... staleIpPermissions);

        /**
         * <p>
         * Information about the stale outbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissionsEgress
         *        Information about the stale outbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress);

        /**
         * <p>
         * Information about the stale outbound rules in the security group.
         * </p>
         * 
         * @param staleIpPermissionsEgress
         *        Information about the stale outbound rules in the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleIpPermissionsEgress(StaleIpPermission... staleIpPermissionsEgress);

        /**
         * <p>
         * The ID of the VPC for the security group.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String groupId;

        private String groupName;

        private List<StaleIpPermission> staleIpPermissions;

        private List<StaleIpPermission> staleIpPermissionsEgress;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(StaleSecurityGroup model) {
            description(model.description);
            groupId(model.groupId);
            groupName(model.groupName);
            staleIpPermissions(model.staleIpPermissions);
            staleIpPermissionsEgress(model.staleIpPermissionsEgress);
            vpcId(model.vpcId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getGroupId() {
            return groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<StaleIpPermission.Builder> getStaleIpPermissions() {
            return staleIpPermissions != null ? staleIpPermissions.stream().map(StaleIpPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleIpPermissions(Collection<StaleIpPermission> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copy(staleIpPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissions(StaleIpPermission... staleIpPermissions) {
            staleIpPermissions(Arrays.asList(staleIpPermissions));
            return this;
        }

        public final void setStaleIpPermissions(Collection<StaleIpPermission.BuilderImpl> staleIpPermissions) {
            this.staleIpPermissions = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissions);
        }

        public final Collection<StaleIpPermission.Builder> getStaleIpPermissionsEgress() {
            return staleIpPermissionsEgress != null ? staleIpPermissionsEgress.stream().map(StaleIpPermission::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder staleIpPermissionsEgress(Collection<StaleIpPermission> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copy(staleIpPermissionsEgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleIpPermissionsEgress(StaleIpPermission... staleIpPermissionsEgress) {
            staleIpPermissionsEgress(Arrays.asList(staleIpPermissionsEgress));
            return this;
        }

        public final void setStaleIpPermissionsEgress(Collection<StaleIpPermission.BuilderImpl> staleIpPermissionsEgress) {
            this.staleIpPermissionsEgress = StaleIpPermissionSetCopier.copyFromBuilder(staleIpPermissionsEgress);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public StaleSecurityGroup build() {
            return new StaleSecurityGroup(this);
        }
    }
}
