/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the target groups to attach to a Spot fleet. Spot fleet registers the running Spot instances with these
 * target groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TargetGroupsConfig implements ToCopyableBuilder<TargetGroupsConfig.Builder, TargetGroupsConfig> {
    private final List<TargetGroup> targetGroups;

    private TargetGroupsConfig(BuilderImpl builder) {
        this.targetGroups = builder.targetGroups;
    }

    /**
     * <p>
     * One or more target groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more target groups.
     */
    public List<TargetGroup> targetGroups() {
        return targetGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupsConfig)) {
            return false;
        }
        TargetGroupsConfig other = (TargetGroupsConfig) obj;
        return Objects.equals(targetGroups(), other.targetGroups());
    }

    @Override
    public String toString() {
        return ToString.builder("TargetGroupsConfig").add("TargetGroups", targetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetGroups":
            return Optional.of(clazz.cast(targetGroups()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, TargetGroupsConfig> {
        /**
         * <p>
         * One or more target groups.
         * </p>
         * 
         * @param targetGroups
         *        One or more target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(Collection<TargetGroup> targetGroups);

        /**
         * <p>
         * One or more target groups.
         * </p>
         * 
         * @param targetGroups
         *        One or more target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroups(TargetGroup... targetGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<TargetGroup> targetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupsConfig model) {
            targetGroups(model.targetGroups);
        }

        public final Collection<TargetGroup.Builder> getTargetGroups() {
            return targetGroups != null ? targetGroups.stream().map(TargetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup... targetGroups) {
            targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        public final void setTargetGroups(Collection<TargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public TargetGroupsConfig build() {
            return new TargetGroupsConfig(this);
        }
    }
}
