/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the modification status of an EBS volume.
 * </p>
 * <p>
 * If the volume has never been modified, some element values will be null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeModification implements ToCopyableBuilder<VolumeModification.Builder, VolumeModification> {
    private final String volumeId;

    private final String modificationState;

    private final String statusMessage;

    private final Integer targetSize;

    private final Integer targetIops;

    private final String targetVolumeType;

    private final Integer originalSize;

    private final Integer originalIops;

    private final String originalVolumeType;

    private final Long progress;

    private final Instant startTime;

    private final Instant endTime;

    private VolumeModification(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.modificationState = builder.modificationState;
        this.statusMessage = builder.statusMessage;
        this.targetSize = builder.targetSize;
        this.targetIops = builder.targetIops;
        this.targetVolumeType = builder.targetVolumeType;
        this.originalSize = builder.originalSize;
        this.originalIops = builder.originalIops;
        this.originalVolumeType = builder.originalVolumeType;
        this.progress = builder.progress;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * ID of the volume being modified.
     * </p>
     * 
     * @return ID of the volume being modified.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Current state of modification. Modification state is null for unmodified volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link VolumeModificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #modificationStateString}.
     * </p>
     * 
     * @return Current state of modification. Modification state is null for unmodified volumes.
     * @see VolumeModificationState
     */
    public VolumeModificationState modificationState() {
        return VolumeModificationState.fromValue(modificationState);
    }

    /**
     * <p>
     * Current state of modification. Modification state is null for unmodified volumes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modificationState}
     * will return {@link VolumeModificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #modificationStateString}.
     * </p>
     * 
     * @return Current state of modification. Modification state is null for unmodified volumes.
     * @see VolumeModificationState
     */
    public String modificationStateString() {
        return modificationState;
    }

    /**
     * <p>
     * Generic status message on modification progress or failure.
     * </p>
     * 
     * @return Generic status message on modification progress or failure.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Target size of the volume being modified.
     * </p>
     * 
     * @return Target size of the volume being modified.
     */
    public Integer targetSize() {
        return targetSize;
    }

    /**
     * <p>
     * Target IOPS rate of the volume being modified.
     * </p>
     * 
     * @return Target IOPS rate of the volume being modified.
     */
    public Integer targetIops() {
        return targetIops;
    }

    /**
     * <p>
     * Target EBS volume type of the volume being modified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetVolumeType}
     * will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetVolumeTypeString}.
     * </p>
     * 
     * @return Target EBS volume type of the volume being modified.
     * @see VolumeType
     */
    public VolumeType targetVolumeType() {
        return VolumeType.fromValue(targetVolumeType);
    }

    /**
     * <p>
     * Target EBS volume type of the volume being modified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetVolumeType}
     * will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetVolumeTypeString}.
     * </p>
     * 
     * @return Target EBS volume type of the volume being modified.
     * @see VolumeType
     */
    public String targetVolumeTypeString() {
        return targetVolumeType;
    }

    /**
     * <p>
     * Original size of the volume being modified.
     * </p>
     * 
     * @return Original size of the volume being modified.
     */
    public Integer originalSize() {
        return originalSize;
    }

    /**
     * <p>
     * Original IOPS rate of the volume being modified.
     * </p>
     * 
     * @return Original IOPS rate of the volume being modified.
     */
    public Integer originalIops() {
        return originalIops;
    }

    /**
     * <p>
     * Original EBS volume type of the volume being modified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originalVolumeType} will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #originalVolumeTypeString}.
     * </p>
     * 
     * @return Original EBS volume type of the volume being modified.
     * @see VolumeType
     */
    public VolumeType originalVolumeType() {
        return VolumeType.fromValue(originalVolumeType);
    }

    /**
     * <p>
     * Original EBS volume type of the volume being modified.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originalVolumeType} will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #originalVolumeTypeString}.
     * </p>
     * 
     * @return Original EBS volume type of the volume being modified.
     * @see VolumeType
     */
    public String originalVolumeTypeString() {
        return originalVolumeType;
    }

    /**
     * <p>
     * Modification progress from 0 to 100%.
     * </p>
     * 
     * @return Modification progress from 0 to 100%.
     */
    public Long progress() {
        return progress;
    }

    /**
     * <p>
     * Modification start time
     * </p>
     * 
     * @return Modification start time
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Modification completion or failure time.
     * </p>
     * 
     * @return Modification completion or failure time.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(modificationStateString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(targetSize());
        hashCode = 31 * hashCode + Objects.hashCode(targetIops());
        hashCode = 31 * hashCode + Objects.hashCode(targetVolumeTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(originalSize());
        hashCode = 31 * hashCode + Objects.hashCode(originalIops());
        hashCode = 31 * hashCode + Objects.hashCode(originalVolumeTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeModification)) {
            return false;
        }
        VolumeModification other = (VolumeModification) obj;
        return Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(modificationStateString(), other.modificationStateString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(targetSize(), other.targetSize())
                && Objects.equals(targetIops(), other.targetIops())
                && Objects.equals(targetVolumeTypeString(), other.targetVolumeTypeString())
                && Objects.equals(originalSize(), other.originalSize()) && Objects.equals(originalIops(), other.originalIops())
                && Objects.equals(originalVolumeTypeString(), other.originalVolumeTypeString())
                && Objects.equals(progress(), other.progress()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime());
    }

    @Override
    public String toString() {
        return ToString.builder("VolumeModification").add("VolumeId", volumeId())
                .add("ModificationState", modificationStateString()).add("StatusMessage", statusMessage())
                .add("TargetSize", targetSize()).add("TargetIops", targetIops())
                .add("TargetVolumeType", targetVolumeTypeString()).add("OriginalSize", originalSize())
                .add("OriginalIops", originalIops()).add("OriginalVolumeType", originalVolumeTypeString())
                .add("Progress", progress()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        case "ModificationState":
            return Optional.of(clazz.cast(modificationStateString()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        case "TargetSize":
            return Optional.of(clazz.cast(targetSize()));
        case "TargetIops":
            return Optional.of(clazz.cast(targetIops()));
        case "TargetVolumeType":
            return Optional.of(clazz.cast(targetVolumeTypeString()));
        case "OriginalSize":
            return Optional.of(clazz.cast(originalSize()));
        case "OriginalIops":
            return Optional.of(clazz.cast(originalIops()));
        case "OriginalVolumeType":
            return Optional.of(clazz.cast(originalVolumeTypeString()));
        case "Progress":
            return Optional.of(clazz.cast(progress()));
        case "StartTime":
            return Optional.of(clazz.cast(startTime()));
        case "EndTime":
            return Optional.of(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeModification> {
        /**
         * <p>
         * ID of the volume being modified.
         * </p>
         * 
         * @param volumeId
         *        ID of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Current state of modification. Modification state is null for unmodified volumes.
         * </p>
         * 
         * @param modificationState
         *        Current state of modification. Modification state is null for unmodified volumes.
         * @see VolumeModificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeModificationState
         */
        Builder modificationState(String modificationState);

        /**
         * <p>
         * Current state of modification. Modification state is null for unmodified volumes.
         * </p>
         * 
         * @param modificationState
         *        Current state of modification. Modification state is null for unmodified volumes.
         * @see VolumeModificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeModificationState
         */
        Builder modificationState(VolumeModificationState modificationState);

        /**
         * <p>
         * Generic status message on modification progress or failure.
         * </p>
         * 
         * @param statusMessage
         *        Generic status message on modification progress or failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Target size of the volume being modified.
         * </p>
         * 
         * @param targetSize
         *        Target size of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSize(Integer targetSize);

        /**
         * <p>
         * Target IOPS rate of the volume being modified.
         * </p>
         * 
         * @param targetIops
         *        Target IOPS rate of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIops(Integer targetIops);

        /**
         * <p>
         * Target EBS volume type of the volume being modified.
         * </p>
         * 
         * @param targetVolumeType
         *        Target EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder targetVolumeType(String targetVolumeType);

        /**
         * <p>
         * Target EBS volume type of the volume being modified.
         * </p>
         * 
         * @param targetVolumeType
         *        Target EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder targetVolumeType(VolumeType targetVolumeType);

        /**
         * <p>
         * Original size of the volume being modified.
         * </p>
         * 
         * @param originalSize
         *        Original size of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalSize(Integer originalSize);

        /**
         * <p>
         * Original IOPS rate of the volume being modified.
         * </p>
         * 
         * @param originalIops
         *        Original IOPS rate of the volume being modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalIops(Integer originalIops);

        /**
         * <p>
         * Original EBS volume type of the volume being modified.
         * </p>
         * 
         * @param originalVolumeType
         *        Original EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder originalVolumeType(String originalVolumeType);

        /**
         * <p>
         * Original EBS volume type of the volume being modified.
         * </p>
         * 
         * @param originalVolumeType
         *        Original EBS volume type of the volume being modified.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder originalVolumeType(VolumeType originalVolumeType);

        /**
         * <p>
         * Modification progress from 0 to 100%.
         * </p>
         * 
         * @param progress
         *        Modification progress from 0 to 100%.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(Long progress);

        /**
         * <p>
         * Modification start time
         * </p>
         * 
         * @param startTime
         *        Modification start time
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Modification completion or failure time.
         * </p>
         * 
         * @param endTime
         *        Modification completion or failure time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String volumeId;

        private String modificationState;

        private String statusMessage;

        private Integer targetSize;

        private Integer targetIops;

        private String targetVolumeType;

        private Integer originalSize;

        private Integer originalIops;

        private String originalVolumeType;

        private Long progress;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeModification model) {
            volumeId(model.volumeId);
            modificationState(model.modificationState);
            statusMessage(model.statusMessage);
            targetSize(model.targetSize);
            targetIops(model.targetIops);
            targetVolumeType(model.targetVolumeType);
            originalSize(model.originalSize);
            originalIops(model.originalIops);
            originalVolumeType(model.originalVolumeType);
            progress(model.progress);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getModificationState() {
            return modificationState;
        }

        @Override
        public final Builder modificationState(String modificationState) {
            this.modificationState = modificationState;
            return this;
        }

        @Override
        public final Builder modificationState(VolumeModificationState modificationState) {
            this.modificationState(modificationState.toString());
            return this;
        }

        public final void setModificationState(String modificationState) {
            this.modificationState = modificationState;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Integer getTargetSize() {
            return targetSize;
        }

        @Override
        public final Builder targetSize(Integer targetSize) {
            this.targetSize = targetSize;
            return this;
        }

        public final void setTargetSize(Integer targetSize) {
            this.targetSize = targetSize;
        }

        public final Integer getTargetIops() {
            return targetIops;
        }

        @Override
        public final Builder targetIops(Integer targetIops) {
            this.targetIops = targetIops;
            return this;
        }

        public final void setTargetIops(Integer targetIops) {
            this.targetIops = targetIops;
        }

        public final String getTargetVolumeType() {
            return targetVolumeType;
        }

        @Override
        public final Builder targetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
            return this;
        }

        @Override
        public final Builder targetVolumeType(VolumeType targetVolumeType) {
            this.targetVolumeType(targetVolumeType.toString());
            return this;
        }

        public final void setTargetVolumeType(String targetVolumeType) {
            this.targetVolumeType = targetVolumeType;
        }

        public final Integer getOriginalSize() {
            return originalSize;
        }

        @Override
        public final Builder originalSize(Integer originalSize) {
            this.originalSize = originalSize;
            return this;
        }

        public final void setOriginalSize(Integer originalSize) {
            this.originalSize = originalSize;
        }

        public final Integer getOriginalIops() {
            return originalIops;
        }

        @Override
        public final Builder originalIops(Integer originalIops) {
            this.originalIops = originalIops;
            return this;
        }

        public final void setOriginalIops(Integer originalIops) {
            this.originalIops = originalIops;
        }

        public final String getOriginalVolumeType() {
            return originalVolumeType;
        }

        @Override
        public final Builder originalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
            return this;
        }

        @Override
        public final Builder originalVolumeType(VolumeType originalVolumeType) {
            this.originalVolumeType(originalVolumeType.toString());
            return this;
        }

        public final void setOriginalVolumeType(String originalVolumeType) {
            this.originalVolumeType = originalVolumeType;
        }

        public final Long getProgress() {
            return progress;
        }

        @Override
        public final Builder progress(Long progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(Long progress) {
            this.progress = progress;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public VolumeModification build() {
            return new VolumeModification(this);
        }
    }
}
