/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the volume status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusItem implements ToCopyableBuilder<VolumeStatusItem.Builder, VolumeStatusItem> {
    private final List<VolumeStatusAction> actions;

    private final String availabilityZone;

    private final List<VolumeStatusEvent> events;

    private final String volumeId;

    private final VolumeStatusInfo volumeStatus;

    private VolumeStatusItem(BuilderImpl builder) {
        this.actions = builder.actions;
        this.availabilityZone = builder.availabilityZone;
        this.events = builder.events;
        this.volumeId = builder.volumeId;
        this.volumeStatus = builder.volumeStatus;
    }

    /**
     * <p>
     * The details of the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details of the operation.
     */
    public List<VolumeStatusAction> actions() {
        return actions;
    }

    /**
     * <p>
     * The Availability Zone of the volume.
     * </p>
     * 
     * @return The Availability Zone of the volume.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A list of events associated with the volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of events associated with the volume.
     */
    public List<VolumeStatusEvent> events() {
        return events;
    }

    /**
     * <p>
     * The volume ID.
     * </p>
     * 
     * @return The volume ID.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The volume status.
     * </p>
     * 
     * @return The volume status.
     */
    public VolumeStatusInfo volumeStatus() {
        return volumeStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatus());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusItem)) {
            return false;
        }
        VolumeStatusItem other = (VolumeStatusItem) obj;
        return Objects.equals(actions(), other.actions()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(events(), other.events()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(volumeStatus(), other.volumeStatus());
    }

    @Override
    public String toString() {
        return ToString.builder("VolumeStatusItem").add("Actions", actions()).add("AvailabilityZone", availabilityZone())
                .add("Events", events()).add("VolumeId", volumeId()).add("VolumeStatus", volumeStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Actions":
            return Optional.of(clazz.cast(actions()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Events":
            return Optional.of(clazz.cast(events()));
        case "VolumeId":
            return Optional.of(clazz.cast(volumeId()));
        case "VolumeStatus":
            return Optional.of(clazz.cast(volumeStatus()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusItem> {
        /**
         * <p>
         * The details of the operation.
         * </p>
         * 
         * @param actions
         *        The details of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<VolumeStatusAction> actions);

        /**
         * <p>
         * The details of the operation.
         * </p>
         * 
         * @param actions
         *        The details of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(VolumeStatusAction... actions);

        /**
         * <p>
         * The Availability Zone of the volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A list of events associated with the volume.
         * </p>
         * 
         * @param events
         *        A list of events associated with the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<VolumeStatusEvent> events);

        /**
         * <p>
         * A list of events associated with the volume.
         * </p>
         * 
         * @param events
         *        A list of events associated with the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(VolumeStatusEvent... events);

        /**
         * <p>
         * The volume ID.
         * </p>
         * 
         * @param volumeId
         *        The volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The volume status.
         * </p>
         * 
         * @param volumeStatus
         *        The volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatus(VolumeStatusInfo volumeStatus);

        /**
         * <p>
         * The volume status.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeStatusInfo.Builder} avoiding the need to
         * create one manually via {@link VolumeStatusInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeStatusInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #volumeStatus(VolumeStatusInfo)}.
         * 
         * @param volumeStatus
         *        a consumer that will call methods on {@link VolumeStatusInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeStatus(VolumeStatusInfo)
         */
        default Builder volumeStatus(Consumer<VolumeStatusInfo.Builder> volumeStatus) {
            return volumeStatus(VolumeStatusInfo.builder().apply(volumeStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<VolumeStatusAction> actions;

        private String availabilityZone;

        private List<VolumeStatusEvent> events;

        private String volumeId;

        private VolumeStatusInfo volumeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusItem model) {
            actions(model.actions);
            availabilityZone(model.availabilityZone);
            events(model.events);
            volumeId(model.volumeId);
            volumeStatus(model.volumeStatus);
        }

        public final Collection<VolumeStatusAction.Builder> getActions() {
            return actions != null ? actions.stream().map(VolumeStatusAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VolumeStatusAction... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<VolumeStatusAction.BuilderImpl> actions) {
            this.actions = VolumeStatusActionsListCopier.copyFromBuilder(actions);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<VolumeStatusEvent.Builder> getEvents() {
            return events != null ? events.stream().map(VolumeStatusEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(VolumeStatusEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<VolumeStatusEvent.BuilderImpl> events) {
            this.events = VolumeStatusEventsListCopier.copyFromBuilder(events);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final VolumeStatusInfo.Builder getVolumeStatus() {
            return volumeStatus != null ? volumeStatus.toBuilder() : null;
        }

        @Override
        public final Builder volumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        public final void setVolumeStatus(VolumeStatusInfo.BuilderImpl volumeStatus) {
            this.volumeStatus = volumeStatus != null ? volumeStatus.build() : null;
        }

        @Override
        public VolumeStatusItem build() {
            return new VolumeStatusItem(this);
        }
    }
}
