/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes VPN connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VpnConnectionOptions implements ToCopyableBuilder<VpnConnectionOptions.Builder, VpnConnectionOptions> {
    private final Boolean staticRoutesOnly;

    private VpnConnectionOptions(BuilderImpl builder) {
        this.staticRoutesOnly = builder.staticRoutesOnly;
    }

    /**
     * <p>
     * Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't
     * support BGP.
     * </p>
     * 
     * @return Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that
     *         don't support BGP.
     */
    public Boolean staticRoutesOnly() {
        return staticRoutesOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticRoutesOnly());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnectionOptions)) {
            return false;
        }
        VpnConnectionOptions other = (VpnConnectionOptions) obj;
        return Objects.equals(staticRoutesOnly(), other.staticRoutesOnly());
    }

    @Override
    public String toString() {
        return ToString.builder("VpnConnectionOptions").add("StaticRoutesOnly", staticRoutesOnly()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticRoutesOnly":
            return Optional.of(clazz.cast(staticRoutesOnly()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VpnConnectionOptions> {
        /**
         * <p>
         * Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that
         * don't support BGP.
         * </p>
         * 
         * @param staticRoutesOnly
         *        Indicates whether the VPN connection uses static routes only. Static routes must be used for devices
         *        that don't support BGP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticRoutesOnly(Boolean staticRoutesOnly);
    }

    static final class BuilderImpl implements Builder {
        private Boolean staticRoutesOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnectionOptions model) {
            staticRoutesOnly(model.staticRoutesOnly);
        }

        public final Boolean getStaticRoutesOnly() {
            return staticRoutesOnly;
        }

        @Override
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        @Override
        public VpnConnectionOptions build() {
            return new VpnConnectionOptions(this);
        }
    }
}
