/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeVpcClassicLinkDnsSupportRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeVpcClassicLinkDnsSupportRequestMarshaller implements
        Marshaller<Request<DescribeVpcClassicLinkDnsSupportRequest>, DescribeVpcClassicLinkDnsSupportRequest> {

    public Request<DescribeVpcClassicLinkDnsSupportRequest> marshall(
            DescribeVpcClassicLinkDnsSupportRequest describeVpcClassicLinkDnsSupportRequest) {

        if (describeVpcClassicLinkDnsSupportRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeVpcClassicLinkDnsSupportRequest> request = new DefaultRequest<DescribeVpcClassicLinkDnsSupportRequest>(
                describeVpcClassicLinkDnsSupportRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcClassicLinkDnsSupport");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeVpcClassicLinkDnsSupportRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeVpcClassicLinkDnsSupportRequest.maxResults()));
        }

        if (describeVpcClassicLinkDnsSupportRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeVpcClassicLinkDnsSupportRequest.nextToken()));
        }

        java.util.List<String> describeVpcClassicLinkDnsSupportRequestVpcIdsList = describeVpcClassicLinkDnsSupportRequest
                .vpcIds();
        if (describeVpcClassicLinkDnsSupportRequestVpcIdsList != null) {
            int vpcIdsListIndex = 1;

            for (String describeVpcClassicLinkDnsSupportRequestVpcIdsListValue : describeVpcClassicLinkDnsSupportRequestVpcIdsList) {
                if (describeVpcClassicLinkDnsSupportRequestVpcIdsListValue != null) {
                    request.addParameter("VpcIds." + vpcIdsListIndex,
                            StringUtils.fromString(describeVpcClassicLinkDnsSupportRequestVpcIdsListValue));
                }
                vpcIdsListIndex++;
            }
        }

        return request;
    }

}
