/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * InternetGateway StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class InternetGatewayUnmarshaller implements Unmarshaller<InternetGateway, StaxUnmarshallerContext> {

    public InternetGateway unmarshall(StaxUnmarshallerContext context) throws Exception {
        InternetGateway.Builder internetGateway = InternetGateway.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<InternetGatewayAttachment> attachments = null;
        java.util.List<Tag> tags = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                internetGateway.attachments(attachments);
                internetGateway.tags(tags);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("attachmentSet", targetDepth)) {
                    attachments = new ArrayList<InternetGatewayAttachment>();
                    continue;
                }

                if (context.testExpression("attachmentSet/item", targetDepth)) {
                    attachments.add(InternetGatewayAttachmentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("internetGatewayId", targetDepth)) {
                    internetGateway.internetGatewayId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("tagSet", targetDepth)) {
                    tags = new ArrayList<Tag>();
                    continue;
                }

                if (context.testExpression("tagSet/item", targetDepth)) {
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    internetGateway.attachments(attachments);
                    internetGateway.tags(tags);
                    break;
                }
            }
        }
        return internetGateway.build();
    }

    private static final InternetGatewayUnmarshaller INSTANCE = new InternetGatewayUnmarshaller();

    public static InternetGatewayUnmarshaller getInstance() {
        return INSTANCE;
    }
}
