/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * LoadPermissionModifications StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class LoadPermissionModificationsUnmarshaller implements
        Unmarshaller<LoadPermissionModifications, StaxUnmarshallerContext> {

    public LoadPermissionModifications unmarshall(StaxUnmarshallerContext context) throws Exception {
        LoadPermissionModifications.Builder loadPermissionModifications = LoadPermissionModifications.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<LoadPermissionRequest> add = null;
        java.util.List<LoadPermissionRequest> remove = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                loadPermissionModifications.add(add);
                loadPermissionModifications.remove(remove);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Add", targetDepth)) {
                    add = new ArrayList<LoadPermissionRequest>();
                    continue;
                }

                if (context.testExpression("Add/item", targetDepth)) {
                    add.add(LoadPermissionRequestUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Remove", targetDepth)) {
                    remove = new ArrayList<LoadPermissionRequest>();
                    continue;
                }

                if (context.testExpression("Remove/item", targetDepth)) {
                    remove.add(LoadPermissionRequestUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    loadPermissionModifications.add(add);
                    loadPermissionModifications.remove(remove);
                    break;
                }
            }
        }
        return loadPermissionModifications.build();
    }

    private static final LoadPermissionModificationsUnmarshaller INSTANCE = new LoadPermissionModificationsUnmarshaller();

    public static LoadPermissionModificationsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
