/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.PermissionGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateVolumePermission
implements ToCopyableBuilder<Builder, CreateVolumePermission> {
    private final String group;
    private final String userId;

    private CreateVolumePermission(BuilderImpl builder) {
        this.group = builder.group;
        this.userId = builder.userId;
    }

    public PermissionGroup group() {
        return PermissionGroup.fromValue(this.group);
    }

    public String groupString() {
        return this.group;
    }

    public String userId() {
        return this.userId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumePermission)) {
            return false;
        }
        CreateVolumePermission other = (CreateVolumePermission)obj;
        return Objects.equals(this.groupString(), other.groupString()) && Objects.equals(this.userId(), other.userId());
    }

    public String toString() {
        return ToString.builder((String)"CreateVolumePermission").add("Group", (Object)this.groupString()).add("UserId", (Object)this.userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Group": {
                return Optional.of(clazz.cast(this.groupString()));
            }
            case "UserId": {
                return Optional.of(clazz.cast(this.userId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String group;
        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumePermission model) {
            this.group(model.group);
            this.userId(model.userId);
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public CreateVolumePermission build() {
            return new CreateVolumePermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateVolumePermission> {
        public Builder group(String var1);

        public Builder group(PermissionGroup var1);

        public Builder userId(String var1);
    }
}

