/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionStateCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterfacePermissionState
implements ToCopyableBuilder<Builder, NetworkInterfacePermissionState> {
    private final String state;
    private final String statusMessage;

    private NetworkInterfacePermissionState(BuilderImpl builder) {
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    public NetworkInterfacePermissionStateCode state() {
        return NetworkInterfacePermissionStateCode.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePermissionState)) {
            return false;
        }
        NetworkInterfacePermissionState other = (NetworkInterfacePermissionState)obj;
        return Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInterfacePermissionState").add("State", (Object)this.stateString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StatusMessage": {
                return Optional.of(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePermissionState model) {
            this.state(model.state);
            this.statusMessage(model.statusMessage);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(NetworkInterfacePermissionStateCode state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public NetworkInterfacePermissionState build() {
            return new NetworkInterfacePermissionState(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfacePermissionState> {
        public Builder state(String var1);

        public Builder state(NetworkInterfacePermissionStateCode var1);

        public Builder statusMessage(String var1);
    }
}

