/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesModificationsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModification;

public final class DescribeReservedInstancesModificationsPaginator
implements SdkIterable<DescribeReservedInstancesModificationsResponse> {
    private final EC2Client client;
    private final DescribeReservedInstancesModificationsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedInstancesModificationsPaginator(EC2Client client, DescribeReservedInstancesModificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedInstancesModificationsResponseFetcher();
    }

    public Iterator<DescribeReservedInstancesModificationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedInstancesModification> reservedInstancesModifications() {
        Function<DescribeReservedInstancesModificationsResponse, Iterator> getIterator = response -> response != null ? response.reservedInstancesModifications().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedInstancesModificationsResponseFetcher
    implements NextPageFetcher<DescribeReservedInstancesModificationsResponse> {
        private DescribeReservedInstancesModificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeReservedInstancesModificationsResponse nextPage(DescribeReservedInstancesModificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesModificationsPaginator.this.client.describeReservedInstancesModifications(DescribeReservedInstancesModificationsPaginator.this.firstRequest);
            }
            return DescribeReservedInstancesModificationsPaginator.this.client.describeReservedInstancesModifications((DescribeReservedInstancesModificationsRequest)((Object)DescribeReservedInstancesModificationsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

