/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BundleTask;
import software.amazon.awssdk.services.ec2.transform.BundleTaskErrorUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.StorageUnmarshaller;

public class BundleTaskUnmarshaller
implements Unmarshaller<BundleTask, StaxUnmarshallerContext> {
    private static final BundleTaskUnmarshaller INSTANCE = new BundleTaskUnmarshaller();

    public BundleTask unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        BundleTask.Builder bundleTask = BundleTask.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("bundleId", targetDepth)) {
                    bundleTask.bundleId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("error", targetDepth)) {
                    bundleTask.bundleTaskError(BundleTaskErrorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceId", targetDepth)) {
                    bundleTask.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("progress", targetDepth)) {
                    bundleTask.progress(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("startTime", targetDepth)) {
                    bundleTask.startTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    bundleTask.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("storage", targetDepth)) {
                    bundleTask.storage(StorageUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("updateTime", targetDepth)) continue;
                bundleTask.updateTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (BundleTask)bundleTask.build();
    }

    public static BundleTaskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

