/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribePrefixListsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribePrefixListsRequestMarshaller
implements Marshaller<Request<DescribePrefixListsRequest>, DescribePrefixListsRequest> {
    public Request<DescribePrefixListsRequest> marshall(DescribePrefixListsRequest describePrefixListsRequest) {
        List<String> describePrefixListsRequestPrefixListIdsList;
        if (describePrefixListsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describePrefixListsRequest, "EC2Client");
        request.addParameter("Action", "DescribePrefixLists");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describePrefixListsRequestFiltersList = describePrefixListsRequest.filters();
        if (describePrefixListsRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describePrefixListsRequestFiltersListValue : describePrefixListsRequestFiltersList) {
                List<String> filterValuesList;
                if (describePrefixListsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describePrefixListsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describePrefixListsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describePrefixListsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describePrefixListsRequest.maxResults()));
        }
        if (describePrefixListsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describePrefixListsRequest.nextToken()));
        }
        if ((describePrefixListsRequestPrefixListIdsList = describePrefixListsRequest.prefixListIds()) != null) {
            int prefixListIdsListIndex = 1;
            for (String describePrefixListsRequestPrefixListIdsListValue : describePrefixListsRequestPrefixListIdsList) {
                if (describePrefixListsRequestPrefixListIdsListValue != null) {
                    request.addParameter("PrefixListId." + prefixListIdsListIndex, StringUtils.fromString((String)describePrefixListsRequestPrefixListIdsListValue));
                }
                ++prefixListIdsListIndex;
            }
        }
        return request;
    }
}

