/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.S3Storage;

public class S3StorageUnmarshaller
implements Unmarshaller<S3Storage, StaxUnmarshallerContext> {
    private static final S3StorageUnmarshaller INSTANCE = new S3StorageUnmarshaller();

    public S3Storage unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        S3Storage.Builder s3Storage = S3Storage.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AWSAccessKeyId", targetDepth)) {
                    s3Storage.awsAccessKeyId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("bucket", targetDepth)) {
                    s3Storage.bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("prefix", targetDepth)) {
                    s3Storage.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("uploadPolicy", targetDepth)) {
                    s3Storage.uploadPolicy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("uploadPolicySignature", targetDepth)) continue;
                s3Storage.uploadPolicySignature(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (S3Storage)s3Storage.build();
    }

    public static S3StorageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

