/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;

public class StartInstancesRequestMarshaller
implements Marshaller<Request<StartInstancesRequest>, StartInstancesRequest> {
    public Request<StartInstancesRequest> marshall(StartInstancesRequest startInstancesRequest) {
        if (startInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)startInstancesRequest, "EC2Client");
        request.addParameter("Action", "StartInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> startInstancesRequestInstanceIdsList = startInstancesRequest.instanceIds();
        if (startInstancesRequestInstanceIdsList != null) {
            int instanceIdsListIndex = 1;
            for (String startInstancesRequestInstanceIdsListValue : startInstancesRequestInstanceIdsList) {
                if (startInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)startInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (startInstancesRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)startInstancesRequest.additionalInfo()));
        }
        return request;
    }
}

