/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AcceptVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AcceptVpcPeeringConnectionResponse extends EC2Response implements
        ToCopyableBuilder<AcceptVpcPeeringConnectionResponse.Builder, AcceptVpcPeeringConnectionResponse> {
    private final VpcPeeringConnection vpcPeeringConnection;

    private AcceptVpcPeeringConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.vpcPeeringConnection = builder.vpcPeeringConnection;
    }

    /**
     * <p>
     * Information about the VPC peering connection.
     * </p>
     * 
     * @return Information about the VPC peering connection.
     */
    public VpcPeeringConnection vpcPeeringConnection() {
        return vpcPeeringConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptVpcPeeringConnectionResponse)) {
            return false;
        }
        AcceptVpcPeeringConnectionResponse other = (AcceptVpcPeeringConnectionResponse) obj;
        return Objects.equals(vpcPeeringConnection(), other.vpcPeeringConnection());
    }

    @Override
    public String toString() {
        return ToString.builder("AcceptVpcPeeringConnectionResponse").add("VpcPeeringConnection", vpcPeeringConnection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcPeeringConnection":
            return Optional.of(clazz.cast(vpcPeeringConnection()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, AcceptVpcPeeringConnectionResponse> {
        /**
         * <p>
         * Information about the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnection
         *        Information about the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection);

        /**
         * <p>
         * Information about the VPC peering connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcPeeringConnection.Builder} avoiding the need
         * to create one manually via {@link VpcPeeringConnection#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcPeeringConnection.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcPeeringConnection(VpcPeeringConnection)}.
         * 
         * @param vpcPeeringConnection
         *        a consumer that will call methods on {@link VpcPeeringConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcPeeringConnection(VpcPeeringConnection)
         */
        default Builder vpcPeeringConnection(Consumer<VpcPeeringConnection.Builder> vpcPeeringConnection) {
            return vpcPeeringConnection(VpcPeeringConnection.builder().apply(vpcPeeringConnection).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private VpcPeeringConnection vpcPeeringConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptVpcPeeringConnectionResponse model) {
            vpcPeeringConnection(model.vpcPeeringConnection);
        }

        public final VpcPeeringConnection.Builder getVpcPeeringConnection() {
            return vpcPeeringConnection != null ? vpcPeeringConnection.toBuilder() : null;
        }

        @Override
        public final Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection;
            return this;
        }

        public final void setVpcPeeringConnection(VpcPeeringConnection.BuilderImpl vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection != null ? vpcPeeringConnection.build() : null;
        }

        @Override
        public AcceptVpcPeeringConnectionResponse build() {
            return new AcceptVpcPeeringConnectionResponse(this);
        }
    }
}
