/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic IP address.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Address implements ToCopyableBuilder<Address.Builder, Address> {
    private final String instanceId;

    private final String publicIp;

    private final String allocationId;

    private final String associationId;

    private final String domain;

    private final String networkInterfaceId;

    private final String networkInterfaceOwnerId;

    private final String privateIpAddress;

    private Address(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.domain = builder.domain;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfaceOwnerId = builder.networkInterfaceOwnerId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    /**
     * <p>
     * The ID of the instance that the address is associated with (if any).
     * </p>
     * 
     * @return The ID of the instance that the address is associated with (if any).
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The Elastic IP address.
     * </p>
     * 
     * @return The Elastic IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The ID representing the allocation of the address for use with EC2-VPC.
     * </p>
     * 
     * @return The ID representing the allocation of the address for use with EC2-VPC.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The ID representing the association of the address with an instance in a VPC.
     * </p>
     * 
     * @return The ID representing the association of the address with an instance in a VPC.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
     * instances in a VPC (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainString}.
     * </p>
     * 
     * @return Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>
     *         ) or instances in a VPC (<code>vpc</code>).
     * @see DomainType
     */
    public DomainType domain() {
        return DomainType.fromValue(domain);
    }

    /**
     * <p>
     * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
     * instances in a VPC (<code>vpc</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainString}.
     * </p>
     * 
     * @return Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>
     *         ) or instances in a VPC (<code>vpc</code>).
     * @see DomainType
     */
    public String domainString() {
        return domain;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the network interface.
     * </p>
     * 
     * @return The ID of the AWS account that owns the network interface.
     */
    public String networkInterfaceOwnerId() {
        return networkInterfaceOwnerId;
    }

    /**
     * <p>
     * The private IP address associated with the Elastic IP address.
     * </p>
     * 
     * @return The private IP address associated with the Elastic IP address.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(domainString());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(publicIp(), other.publicIp())
                && Objects.equals(allocationId(), other.allocationId()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(domainString(), other.domainString())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(networkInterfaceOwnerId(), other.networkInterfaceOwnerId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress());
    }

    @Override
    public String toString() {
        return ToString.builder("Address").add("InstanceId", instanceId()).add("PublicIp", publicIp())
                .add("AllocationId", allocationId()).add("AssociationId", associationId()).add("Domain", domainString())
                .add("NetworkInterfaceId", networkInterfaceId()).add("NetworkInterfaceOwnerId", networkInterfaceOwnerId())
                .add("PrivateIpAddress", privateIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "PublicIp":
            return Optional.of(clazz.cast(publicIp()));
        case "AllocationId":
            return Optional.of(clazz.cast(allocationId()));
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        case "Domain":
            return Optional.of(clazz.cast(domainString()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "NetworkInterfaceOwnerId":
            return Optional.of(clazz.cast(networkInterfaceOwnerId()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The ID of the instance that the address is associated with (if any).
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance that the address is associated with (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The Elastic IP address.
         * </p>
         * 
         * @param publicIp
         *        The Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The ID representing the allocation of the address for use with EC2-VPC.
         * </p>
         * 
         * @param allocationId
         *        The ID representing the allocation of the address for use with EC2-VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The ID representing the association of the address with an instance in a VPC.
         * </p>
         * 
         * @param associationId
         *        The ID representing the association of the address with an instance in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * Indicates whether this Elastic IP address is for use with instances in EC2-Classic (<code>standard</code>) or
         * instances in a VPC (<code>vpc</code>).
         * </p>
         * 
         * @param domain
         *        Indicates whether this Elastic IP address is for use with instances in EC2-Classic (
         *        <code>standard</code>) or instances in a VPC (<code>vpc</code>).
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the AWS account that owns the network interface.
         * </p>
         * 
         * @param networkInterfaceOwnerId
         *        The ID of the AWS account that owns the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceOwnerId(String networkInterfaceOwnerId);

        /**
         * <p>
         * The private IP address associated with the Elastic IP address.
         * </p>
         * 
         * @param privateIpAddress
         *        The private IP address associated with the Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String publicIp;

        private String allocationId;

        private String associationId;

        private String domain;

        private String networkInterfaceId;

        private String networkInterfaceOwnerId;

        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            instanceId(model.instanceId);
            publicIp(model.publicIp);
            allocationId(model.allocationId);
            associationId(model.associationId);
            domain(model.domain);
            networkInterfaceId(model.networkInterfaceId);
            networkInterfaceOwnerId(model.networkInterfaceOwnerId);
            privateIpAddress(model.privateIpAddress);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getNetworkInterfaceOwnerId() {
            return networkInterfaceOwnerId;
        }

        @Override
        public final Builder networkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
            return this;
        }

        public final void setNetworkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public Address build() {
            return new Address(this);
        }
    }
}
