/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelReservedInstancesListingRequest extends EC2Request implements
        ToCopyableBuilder<CancelReservedInstancesListingRequest.Builder, CancelReservedInstancesListingRequest> {
    private final String reservedInstancesListingId;

    private CancelReservedInstancesListingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance listing.
     * </p>
     * 
     * @return The ID of the Reserved Instance listing.
     */
    public String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesListingId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelReservedInstancesListingRequest)) {
            return false;
        }
        CancelReservedInstancesListingRequest other = (CancelReservedInstancesListingRequest) obj;
        return Objects.equals(reservedInstancesListingId(), other.reservedInstancesListingId());
    }

    @Override
    public String toString() {
        return ToString.builder("CancelReservedInstancesListingRequest")
                .add("ReservedInstancesListingId", reservedInstancesListingId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesListingId":
            return Optional.of(clazz.cast(reservedInstancesListingId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CancelReservedInstancesListingRequest> {
        /**
         * <p>
         * The ID of the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        The ID of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String reservedInstancesListingId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelReservedInstancesListingRequest model) {
            reservedInstancesListingId(model.reservedInstancesListingId);
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelReservedInstancesListingRequest build() {
            return new CancelReservedInstancesListingRequest(this);
        }
    }
}
