/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the Snapshot object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSnapshotResponse extends EC2Response implements
        ToCopyableBuilder<CreateSnapshotResponse.Builder, CreateSnapshotResponse> {
    private final Snapshot snapshot;

    private CreateSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshot = builder.snapshot;
    }

    /**
     * <p>
     * Describes a snapshot.
     * </p>
     * 
     * @return Describes a snapshot.
     */
    public Snapshot snapshot() {
        return snapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshot());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotResponse)) {
            return false;
        }
        CreateSnapshotResponse other = (CreateSnapshotResponse) obj;
        return Objects.equals(snapshot(), other.snapshot());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateSnapshotResponse").add("Snapshot", snapshot()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Snapshot":
            return Optional.of(clazz.cast(snapshot()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateSnapshotResponse> {
        /**
         * <p>
         * Describes a snapshot.
         * </p>
         * 
         * @param snapshot
         *        Describes a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshot(Snapshot snapshot);

        /**
         * <p>
         * Describes a snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link Snapshot.Builder} avoiding the need to create
         * one manually via {@link Snapshot#builder()}.
         *
         * When the {@link Consumer} completes, {@link Snapshot.Builder#build()} is called immediately and its result is
         * passed to {@link #snapshot(Snapshot)}.
         * 
         * @param snapshot
         *        a consumer that will call methods on {@link Snapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshot(Snapshot)
         */
        default Builder snapshot(Consumer<Snapshot.Builder> snapshot) {
            return snapshot(Snapshot.builder().apply(snapshot).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private Snapshot snapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotResponse model) {
            snapshot(model.snapshot);
        }

        public final Snapshot.Builder getSnapshot() {
            return snapshot != null ? snapshot.toBuilder() : null;
        }

        @Override
        public final Builder snapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public final void setSnapshot(Snapshot.BuilderImpl snapshot) {
            this.snapshot = snapshot != null ? snapshot.build() : null;
        }

        @Override
        public CreateSnapshotResponse build() {
            return new CreateSnapshotResponse(this);
        }
    }
}
