/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A simple result wrapper around the Volume object that was sent over the wire.
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVolumeResponse extends EC2Response implements
        ToCopyableBuilder<CreateVolumeResponse.Builder, CreateVolumeResponse> {
    private final Volume volume;

    private CreateVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.volume = builder.volume;
    }

    /**
     * <p>
     * Describes a volume.
     * </p>
     * 
     * @return Describes a volume.
     */
    public Volume volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volume());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeResponse)) {
            return false;
        }
        CreateVolumeResponse other = (CreateVolumeResponse) obj;
        return Objects.equals(volume(), other.volume());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVolumeResponse").add("Volume", volume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Volume":
            return Optional.of(clazz.cast(volume()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateVolumeResponse> {
        /**
         * <p>
         * Describes a volume.
         * </p>
         * 
         * @param volume
         *        Describes a volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(Volume volume);

        /**
         * <p>
         * Describes a volume.
         * </p>
         * This is a convenience that creates an instance of the {@link Volume.Builder} avoiding the need to create one
         * manually via {@link Volume#builder()}.
         *
         * When the {@link Consumer} completes, {@link Volume.Builder#build()} is called immediately and its result is
         * passed to {@link #volume(Volume)}.
         * 
         * @param volume
         *        a consumer that will call methods on {@link Volume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volume(Volume)
         */
        default Builder volume(Consumer<Volume.Builder> volume) {
            return volume(Volume.builder().apply(volume).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private Volume volume;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeResponse model) {
            volume(model.volume);
        }

        public final Volume.Builder getVolume() {
            return volume != null ? volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(Volume.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public CreateVolumeResponse build() {
            return new CreateVolumeResponse(this);
        }
    }
}
