/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpnConnectionRoute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpnConnectionRouteRequest extends EC2Request implements
        ToCopyableBuilder<CreateVpnConnectionRouteRequest.Builder, CreateVpnConnectionRouteRequest> {
    private final String destinationCidrBlock;

    private final String vpnConnectionId;

    private CreateVpnConnectionRouteRequest(BuilderImpl builder) {
        super(builder);
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.vpnConnectionId = builder.vpnConnectionId;
    }

    /**
     * <p>
     * The CIDR block associated with the local subnet of the customer network.
     * </p>
     * 
     * @return The CIDR block associated with the local subnet of the customer network.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The ID of the VPN connection.
     * </p>
     * 
     * @return The ID of the VPN connection.
     */
    public String vpnConnectionId() {
        return vpnConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRouteRequest)) {
            return false;
        }
        CreateVpnConnectionRouteRequest other = (CreateVpnConnectionRouteRequest) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(vpnConnectionId(), other.vpnConnectionId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpnConnectionRouteRequest").add("DestinationCidrBlock", destinationCidrBlock())
                .add("VpnConnectionId", vpnConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.of(clazz.cast(destinationCidrBlock()));
        case "VpnConnectionId":
            return Optional.of(clazz.cast(vpnConnectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateVpnConnectionRouteRequest> {
        /**
         * <p>
         * The CIDR block associated with the local subnet of the customer network.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The CIDR block associated with the local subnet of the customer network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The ID of the VPN connection.
         * </p>
         * 
         * @param vpnConnectionId
         *        The ID of the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionId(String vpnConnectionId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String vpnConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionRouteRequest model) {
            destinationCidrBlock(model.destinationCidrBlock);
            vpnConnectionId(model.vpnConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getVpnConnectionId() {
            return vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVpnConnectionRouteRequest build() {
            return new CreateVpnConnectionRouteRequest(this);
        }
    }
}
