/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a customer gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CustomerGateway implements ToCopyableBuilder<CustomerGateway.Builder, CustomerGateway> {
    private final String bgpAsn;

    private final String customerGatewayId;

    private final String ipAddress;

    private final String state;

    private final String type;

    private final List<Tag> tags;

    private CustomerGateway(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.customerGatewayId = builder.customerGatewayId;
        this.ipAddress = builder.ipAddress;
        this.state = builder.state;
        this.type = builder.type;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     * </p>
     * 
     * @return The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     */
    public String bgpAsn() {
        return bgpAsn;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The Internet-routable IP address of the customer gateway's outside interface.
     * </p>
     * 
     * @return The Internet-routable IP address of the customer gateway's outside interface.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
     * </p>
     * 
     * @return The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
     * </p>
     * 
     * @return The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Any tags assigned to the customer gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the customer gateway.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bgpAsn());
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerGateway)) {
            return false;
        }
        CustomerGateway other = (CustomerGateway) obj;
        return Objects.equals(bgpAsn(), other.bgpAsn()) && Objects.equals(customerGatewayId(), other.customerGatewayId())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(state(), other.state())
                && Objects.equals(type(), other.type()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("CustomerGateway").add("BgpAsn", bgpAsn()).add("CustomerGatewayId", customerGatewayId())
                .add("IpAddress", ipAddress()).add("State", state()).add("Type", type()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BgpAsn":
            return Optional.of(clazz.cast(bgpAsn()));
        case "CustomerGatewayId":
            return Optional.of(clazz.cast(customerGatewayId()));
        case "IpAddress":
            return Optional.of(clazz.cast(ipAddress()));
        case "State":
            return Optional.of(clazz.cast(state()));
        case "Type":
            return Optional.of(clazz.cast(type()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CustomerGateway> {
        /**
         * <p>
         * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * </p>
         * 
         * @param bgpAsn
         *        The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpAsn(String bgpAsn);

        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The Internet-routable IP address of the customer gateway's outside interface.
         * </p>
         * 
         * @param ipAddress
         *        The Internet-routable IP address of the customer gateway's outside interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
         * </p>
         * 
         * @param state
         *        The current state of the customer gateway (<code>pending | available | deleting | deleted</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection the customer gateway supports (<code>ipsec.1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Any tags assigned to the customer gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the customer gateway.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String bgpAsn;

        private String customerGatewayId;

        private String ipAddress;

        private String state;

        private String type;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerGateway model) {
            bgpAsn(model.bgpAsn);
            customerGatewayId(model.customerGatewayId);
            ipAddress(model.ipAddress);
            state(model.state);
            type(model.type);
            tags(model.tags);
        }

        public final String getBgpAsn() {
            return bgpAsn;
        }

        @Override
        public final Builder bgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public CustomerGateway build() {
            return new CustomerGateway(this);
        }
    }
}
