/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteNetworkInterfacePermission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNetworkInterfacePermissionRequest extends EC2Request implements
        ToCopyableBuilder<DeleteNetworkInterfacePermissionRequest.Builder, DeleteNetworkInterfacePermissionRequest> {
    private final String networkInterfacePermissionId;

    private final Boolean force;

    private DeleteNetworkInterfacePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfacePermissionId = builder.networkInterfacePermissionId;
        this.force = builder.force;
    }

    /**
     * <p>
     * The ID of the network interface permission.
     * </p>
     * 
     * @return The ID of the network interface permission.
     */
    public String networkInterfacePermissionId() {
        return networkInterfacePermissionId;
    }

    /**
     * <p>
     * Specify <code>true</code> to remove the permission even if the network interface is attached to an instance.
     * </p>
     * 
     * @return Specify <code>true</code> to remove the permission even if the network interface is attached to an
     *         instance.
     */
    public Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfacePermissionId());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkInterfacePermissionRequest)) {
            return false;
        }
        DeleteNetworkInterfacePermissionRequest other = (DeleteNetworkInterfacePermissionRequest) obj;
        return Objects.equals(networkInterfacePermissionId(), other.networkInterfacePermissionId())
                && Objects.equals(force(), other.force());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteNetworkInterfacePermissionRequest")
                .add("NetworkInterfacePermissionId", networkInterfacePermissionId()).add("Force", force()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfacePermissionId":
            return Optional.of(clazz.cast(networkInterfacePermissionId()));
        case "Force":
            return Optional.of(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DeleteNetworkInterfacePermissionRequest> {
        /**
         * <p>
         * The ID of the network interface permission.
         * </p>
         * 
         * @param networkInterfacePermissionId
         *        The ID of the network interface permission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissionId(String networkInterfacePermissionId);

        /**
         * <p>
         * Specify <code>true</code> to remove the permission even if the network interface is attached to an instance.
         * </p>
         * 
         * @param force
         *        Specify <code>true</code> to remove the permission even if the network interface is attached to an
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String networkInterfacePermissionId;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkInterfacePermissionRequest model) {
            networkInterfacePermissionId(model.networkInterfacePermissionId);
            force(model.force);
        }

        public final String getNetworkInterfacePermissionId() {
            return networkInterfacePermissionId;
        }

        @Override
        public final Builder networkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
            return this;
        }

        public final void setNetworkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
        }

        public final Boolean getForce() {
            return force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteNetworkInterfacePermissionRequest build() {
            return new DeleteNetworkInterfacePermissionRequest(this);
        }
    }
}
