/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeBundleTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeBundleTasksRequest extends EC2Request implements
        ToCopyableBuilder<DescribeBundleTasksRequest.Builder, DescribeBundleTasksRequest> {
    private final List<String> bundleIds;

    private final List<Filter> filters;

    private DescribeBundleTasksRequest(BuilderImpl builder) {
        super(builder);
        this.bundleIds = builder.bundleIds;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * One or more bundle task IDs.
     * </p>
     * <p>
     * Default: Describes all your bundle tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more bundle task IDs.</p>
     *         <p>
     *         Default: Describes all your bundle tasks.
     */
    public List<String> bundleIds() {
        return bundleIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>bundle-id</code> - The ID of the bundle task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error-code</code> - If the task failed, the error code returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>error-message</code> - If the task failed, the error message returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>s3-prefix</code> - The beginning of the AMI name.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
     * <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
     * <code>failed</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update-time</code> - The time of the most recent update for the task.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>bundle-id</code> - The ID of the bundle task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error-code</code> - If the task failed, the error code returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>error-message</code> - If the task failed, the error message returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>s3-prefix</code> - The beginning of the AMI name.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
     *         <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
     *         <code>failed</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update-time</code> - The time of the most recent update for the task.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bundleIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBundleTasksRequest)) {
            return false;
        }
        DescribeBundleTasksRequest other = (DescribeBundleTasksRequest) obj;
        return Objects.equals(bundleIds(), other.bundleIds()) && Objects.equals(filters(), other.filters());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeBundleTasksRequest").add("BundleIds", bundleIds()).add("Filters", filters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BundleIds":
            return Optional.of(clazz.cast(bundleIds()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeBundleTasksRequest> {
        /**
         * <p>
         * One or more bundle task IDs.
         * </p>
         * <p>
         * Default: Describes all your bundle tasks.
         * </p>
         * 
         * @param bundleIds
         *        One or more bundle task IDs.</p>
         *        <p>
         *        Default: Describes all your bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleIds(Collection<String> bundleIds);

        /**
         * <p>
         * One or more bundle task IDs.
         * </p>
         * <p>
         * Default: Describes all your bundle tasks.
         * </p>
         * 
         * @param bundleIds
         *        One or more bundle task IDs.</p>
         *        <p>
         *        Default: Describes all your bundle tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleIds(String... bundleIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bundle-id</code> - The ID of the bundle task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-code</code> - If the task failed, the error code returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-message</code> - If the task failed, the error message returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-prefix</code> - The beginning of the AMI name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         * <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update for the task.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bundle-id</code> - The ID of the bundle task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-code</code> - If the task failed, the error code returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-message</code> - If the task failed, the error message returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-prefix</code> - The beginning of the AMI name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         *        <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update for the task.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>bundle-id</code> - The ID of the bundle task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-code</code> - If the task failed, the error code returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>error-message</code> - If the task failed, the error message returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>s3-prefix</code> - The beginning of the AMI name.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         * <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         * <code>failed</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update-time</code> - The time of the most recent update for the task.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>bundle-id</code> - The ID of the bundle task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-code</code> - If the task failed, the error code returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>error-message</code> - If the task failed, the error message returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>progress</code> - The level of task completion, as a percentage (for example, 20%).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>s3-prefix</code> - The beginning of the AMI name.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> |
         *        <code>bundling</code> | <code>storing</code> | <code>cancelling</code> | <code>complete</code> |
         *        <code>failed</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update-time</code> - The time of the most recent update for the task.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> bundleIds;

        private List<Filter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBundleTasksRequest model) {
            bundleIds(model.bundleIds);
            filters(model.filters);
        }

        public final Collection<String> getBundleIds() {
            return bundleIds;
        }

        @Override
        public final Builder bundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdStringListCopier.copy(bundleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bundleIds(String... bundleIds) {
            bundleIds(Arrays.asList(bundleIds));
            return this;
        }

        public final void setBundleIds(Collection<String> bundleIds) {
            this.bundleIds = BundleIdStringListCopier.copy(bundleIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeBundleTasksRequest build() {
            return new DescribeBundleTasksRequest(this);
        }
    }
}
