/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeImportSnapshotTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImportSnapshotTasksResponse extends EC2Response implements
        ToCopyableBuilder<DescribeImportSnapshotTasksResponse.Builder, DescribeImportSnapshotTasksResponse> {
    private final List<ImportSnapshotTask> importSnapshotTasks;

    private final String nextToken;

    private DescribeImportSnapshotTasksResponse(BuilderImpl builder) {
        super(builder);
        this.importSnapshotTasks = builder.importSnapshotTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
     * previous 7 days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of zero or more import snapshot tasks that are currently active or were completed or canceled in
     *         the previous 7 days.
     */
    public List<ImportSnapshotTask> importSnapshotTasks() {
        return importSnapshotTasks;
    }

    /**
     * <p>
     * The token to use to get the next page of results. This value is <code>null</code> when there are no more results
     * to return.
     * </p>
     * 
     * @return The token to use to get the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importSnapshotTasks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportSnapshotTasksResponse)) {
            return false;
        }
        DescribeImportSnapshotTasksResponse other = (DescribeImportSnapshotTasksResponse) obj;
        return Objects.equals(importSnapshotTasks(), other.importSnapshotTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeImportSnapshotTasksResponse").add("ImportSnapshotTasks", importSnapshotTasks())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportSnapshotTasks":
            return Optional.of(clazz.cast(importSnapshotTasks()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeImportSnapshotTasksResponse> {
        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importSnapshotTasks
         *        A list of zero or more import snapshot tasks that are currently active or were completed or canceled
         *        in the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks);

        /**
         * <p>
         * A list of zero or more import snapshot tasks that are currently active or were completed or canceled in the
         * previous 7 days.
         * </p>
         * 
         * @param importSnapshotTasks
         *        A list of zero or more import snapshot tasks that are currently active or were completed or canceled
         *        in the previous 7 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSnapshotTasks(ImportSnapshotTask... importSnapshotTasks);

        /**
         * <p>
         * The token to use to get the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ImportSnapshotTask> importSnapshotTasks;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportSnapshotTasksResponse model) {
            importSnapshotTasks(model.importSnapshotTasks);
            nextToken(model.nextToken);
        }

        public final Collection<ImportSnapshotTask.Builder> getImportSnapshotTasks() {
            return importSnapshotTasks != null ? importSnapshotTasks.stream().map(ImportSnapshotTask::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder importSnapshotTasks(Collection<ImportSnapshotTask> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copy(importSnapshotTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importSnapshotTasks(ImportSnapshotTask... importSnapshotTasks) {
            importSnapshotTasks(Arrays.asList(importSnapshotTasks));
            return this;
        }

        public final void setImportSnapshotTasks(Collection<ImportSnapshotTask.BuilderImpl> importSnapshotTasks) {
            this.importSnapshotTasks = ImportSnapshotTaskListCopier.copyFromBuilder(importSnapshotTasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImportSnapshotTasksResponse build() {
            return new DescribeImportSnapshotTasksResponse(this);
        }
    }
}
