/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVpnConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpnConnectionsRequest extends EC2Request implements
        ToCopyableBuilder<DescribeVpnConnectionsRequest.Builder, DescribeVpnConnectionsRequest> {
    private final List<Filter> filters;

    private final List<String> vpnConnectionIds;

    private DescribeVpnConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.vpnConnectionIds = builder.vpnConnectionIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
     * <code>deleting</code> | <code>deleted</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
     * devices that do not support Border Gateway Protocol (BGP).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used in a
     * customer data center.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-connection-id</code> - The ID of the VPN connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
     *         <code>deleting</code> | <code>deleted</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
     *         for devices that do not support Border Gateway Protocol (BGP).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
     *         used in a customer data center.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-connection-id</code> - The ID of the VPN connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more VPN connection IDs.
     * </p>
     * <p>
     * Default: Describes your VPN connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more VPN connection IDs.</p>
     *         <p>
     *         Default: Describes your VPN connections.
     */
    public List<String> vpnConnectionIds() {
        return vpnConnectionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(vpnConnectionIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsRequest)) {
            return false;
        }
        DescribeVpnConnectionsRequest other = (DescribeVpnConnectionsRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(vpnConnectionIds(), other.vpnConnectionIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVpnConnectionsRequest").add("Filters", filters())
                .add("VpnConnectionIds", vpnConnectionIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "VpnConnectionIds":
            return Optional.of(clazz.cast(vpnConnectionIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeVpnConnectionsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
         * devices that do not support Border Gateway Protocol (BGP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used
         * in a customer data center.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
         *        for devices that do not support Border Gateway Protocol (BGP).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
         *        used in a customer data center.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of VPN connection. Currently the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
         * devices that do not support Border Gateway Protocol (BGP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used
         * in a customer data center.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
         *        for devices that do not support Border Gateway Protocol (BGP).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
         *        used in a customer data center.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of VPN connection. Currently the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more VPN connection IDs.
         * </p>
         * <p>
         * Default: Describes your VPN connections.
         * </p>
         * 
         * @param vpnConnectionIds
         *        One or more VPN connection IDs.</p>
         *        <p>
         *        Default: Describes your VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionIds(Collection<String> vpnConnectionIds);

        /**
         * <p>
         * One or more VPN connection IDs.
         * </p>
         * <p>
         * Default: Describes your VPN connections.
         * </p>
         * 
         * @param vpnConnectionIds
         *        One or more VPN connection IDs.</p>
         *        <p>
         *        Default: Describes your VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionIds(String... vpnConnectionIds);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> vpnConnectionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsRequest model) {
            filters(model.filters);
            vpnConnectionIds(model.vpnConnectionIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getVpnConnectionIds() {
            return vpnConnectionIds;
        }

        @Override
        public final Builder vpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnectionIds(String... vpnConnectionIds) {
            vpnConnectionIds(Arrays.asList(vpnConnectionIds));
            return this;
        }

        public final void setVpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeVpnConnectionsRequest build() {
            return new DescribeVpnConnectionsRequest(this);
        }
    }
}
