/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExportTask implements ToCopyableBuilder<ExportTask.Builder, ExportTask> {
    private final String description;

    private final String exportTaskId;

    private final ExportToS3Task exportToS3Task;

    private final InstanceExportDetails instanceExportDetails;

    private final String state;

    private final String statusMessage;

    private ExportTask(BuilderImpl builder) {
        this.description = builder.description;
        this.exportTaskId = builder.exportTaskId;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceExportDetails = builder.instanceExportDetails;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * A description of the resource being exported.
     * </p>
     * 
     * @return A description of the resource being exported.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the export task.
     * </p>
     * 
     * @return The ID of the export task.
     */
    public String exportTaskId() {
        return exportTaskId;
    }

    /**
     * <p>
     * Information about the export task.
     * </p>
     * 
     * @return Information about the export task.
     */
    public ExportToS3Task exportToS3Task() {
        return exportToS3Task;
    }

    /**
     * <p>
     * Information about the instance to export.
     * </p>
     * 
     * @return Information about the instance to export.
     */
    public InstanceExportDetails instanceExportDetails() {
        return instanceExportDetails;
    }

    /**
     * <p>
     * The state of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExportTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the export task.
     * @see ExportTaskState
     */
    public ExportTaskState state() {
        return ExportTaskState.fromValue(state);
    }

    /**
     * <p>
     * The state of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ExportTaskState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The state of the export task.
     * @see ExportTaskState
     */
    public String stateString() {
        return state;
    }

    /**
     * <p>
     * The status message related to the export task.
     * </p>
     * 
     * @return The status message related to the export task.
     */
    public String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(exportTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(exportToS3Task());
        hashCode = 31 * hashCode + Objects.hashCode(instanceExportDetails());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(exportTaskId(), other.exportTaskId())
                && Objects.equals(exportToS3Task(), other.exportToS3Task())
                && Objects.equals(instanceExportDetails(), other.instanceExportDetails())
                && Objects.equals(stateString(), other.stateString()) && Objects.equals(statusMessage(), other.statusMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("ExportTask").add("Description", description()).add("ExportTaskId", exportTaskId())
                .add("ExportToS3Task", exportToS3Task()).add("InstanceExportDetails", instanceExportDetails())
                .add("State", stateString()).add("StatusMessage", statusMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "ExportTaskId":
            return Optional.of(clazz.cast(exportTaskId()));
        case "ExportToS3Task":
            return Optional.of(clazz.cast(exportToS3Task()));
        case "InstanceExportDetails":
            return Optional.of(clazz.cast(instanceExportDetails()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ExportTask> {
        /**
         * <p>
         * A description of the resource being exported.
         * </p>
         * 
         * @param description
         *        A description of the resource being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the export task.
         * </p>
         * 
         * @param exportTaskId
         *        The ID of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTaskId(String exportTaskId);

        /**
         * <p>
         * Information about the export task.
         * </p>
         * 
         * @param exportToS3Task
         *        Information about the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportToS3Task(ExportToS3Task exportToS3Task);

        /**
         * <p>
         * Information about the export task.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportToS3Task.Builder} avoiding the need to
         * create one manually via {@link ExportToS3Task#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportToS3Task.Builder#build()} is called immediately and its
         * result is passed to {@link #exportToS3Task(ExportToS3Task)}.
         * 
         * @param exportToS3Task
         *        a consumer that will call methods on {@link ExportToS3Task.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportToS3Task(ExportToS3Task)
         */
        default Builder exportToS3Task(Consumer<ExportToS3Task.Builder> exportToS3Task) {
            return exportToS3Task(ExportToS3Task.builder().apply(exportToS3Task).build());
        }

        /**
         * <p>
         * Information about the instance to export.
         * </p>
         * 
         * @param instanceExportDetails
         *        Information about the instance to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceExportDetails(InstanceExportDetails instanceExportDetails);

        /**
         * <p>
         * Information about the instance to export.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceExportDetails.Builder} avoiding the need
         * to create one manually via {@link InstanceExportDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceExportDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceExportDetails(InstanceExportDetails)}.
         * 
         * @param instanceExportDetails
         *        a consumer that will call methods on {@link InstanceExportDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceExportDetails(InstanceExportDetails)
         */
        default Builder instanceExportDetails(Consumer<InstanceExportDetails.Builder> instanceExportDetails) {
            return instanceExportDetails(InstanceExportDetails.builder().apply(instanceExportDetails).build());
        }

        /**
         * <p>
         * The state of the export task.
         * </p>
         * 
         * @param state
         *        The state of the export task.
         * @see ExportTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the export task.
         * </p>
         * 
         * @param state
         *        The state of the export task.
         * @see ExportTaskState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskState
         */
        Builder state(ExportTaskState state);

        /**
         * <p>
         * The status message related to the export task.
         * </p>
         * 
         * @param statusMessage
         *        The status message related to the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String exportTaskId;

        private ExportToS3Task exportToS3Task;

        private InstanceExportDetails instanceExportDetails;

        private String state;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            description(model.description);
            exportTaskId(model.exportTaskId);
            exportToS3Task(model.exportToS3Task);
            instanceExportDetails(model.instanceExportDetails);
            state(model.state);
            statusMessage(model.statusMessage);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExportTaskId() {
            return exportTaskId;
        }

        @Override
        public final Builder exportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
            return this;
        }

        public final void setExportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
        }

        public final ExportToS3Task.Builder getExportToS3Task() {
            return exportToS3Task != null ? exportToS3Task.toBuilder() : null;
        }

        @Override
        public final Builder exportToS3Task(ExportToS3Task exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final void setExportToS3Task(ExportToS3Task.BuilderImpl exportToS3Task) {
            this.exportToS3Task = exportToS3Task != null ? exportToS3Task.build() : null;
        }

        public final InstanceExportDetails.Builder getInstanceExportDetails() {
            return instanceExportDetails != null ? instanceExportDetails.toBuilder() : null;
        }

        @Override
        public final Builder instanceExportDetails(InstanceExportDetails instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails;
            return this;
        }

        public final void setInstanceExportDetails(InstanceExportDetails.BuilderImpl instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails != null ? instanceExportDetails.build() : null;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ExportTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public ExportTask build() {
            return new ExportTask(this);
        }
    }
}
