/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Host implements ToCopyableBuilder<Host.Builder, Host> {
    private final String autoPlacement;

    private final String availabilityZone;

    private final AvailableCapacity availableCapacity;

    private final String clientToken;

    private final String hostId;

    private final HostProperties hostProperties;

    private final String hostReservationId;

    private final List<HostInstance> instances;

    private final String state;

    private Host(BuilderImpl builder) {
        this.autoPlacement = builder.autoPlacement;
        this.availabilityZone = builder.availabilityZone;
        this.availableCapacity = builder.availableCapacity;
        this.clientToken = builder.clientToken;
        this.hostId = builder.hostId;
        this.hostProperties = builder.hostProperties;
        this.hostReservationId = builder.hostReservationId;
        this.instances = builder.instances;
        this.state = builder.state;
    }

    /**
     * <p>
     * Whether auto-placement is on or off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementString}.
     * </p>
     * 
     * @return Whether auto-placement is on or off.
     * @see AutoPlacement
     */
    public AutoPlacement autoPlacement() {
        return AutoPlacement.fromValue(autoPlacement);
    }

    /**
     * <p>
     * Whether auto-placement is on or off.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoPlacement}
     * will return {@link AutoPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #autoPlacementString}.
     * </p>
     * 
     * @return Whether auto-placement is on or off.
     * @see AutoPlacement
     */
    public String autoPlacementString() {
        return autoPlacement;
    }

    /**
     * <p>
     * The Availability Zone of the Dedicated Host.
     * </p>
     * 
     * @return The Availability Zone of the Dedicated Host.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of new instances that can be launched onto the Dedicated Host.
     * </p>
     * 
     * @return The number of new instances that can be launched onto the Dedicated Host.
     */
    public AvailableCapacity availableCapacity() {
        return availableCapacity;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to
     *         Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Dedicated Host.
     * </p>
     * 
     * @return The ID of the Dedicated Host.
     */
    public String hostId() {
        return hostId;
    }

    /**
     * <p>
     * The hardware specifications of the Dedicated Host.
     * </p>
     * 
     * @return The hardware specifications of the Dedicated Host.
     */
    public HostProperties hostProperties() {
        return hostProperties;
    }

    /**
     * <p>
     * The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated Host doesn't
     * have an associated reservation.
     * </p>
     * 
     * @return The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated Host
     *         doesn't have an associated reservation.
     */
    public String hostReservationId() {
        return hostReservationId;
    }

    /**
     * <p>
     * The IDs and instance type that are currently running on the Dedicated Host.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs and instance type that are currently running on the Dedicated Host.
     */
    public List<HostInstance> instances() {
        return instances;
    }

    /**
     * <p>
     * The Dedicated Host's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AllocationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The Dedicated Host's state.
     * @see AllocationState
     */
    public AllocationState state() {
        return AllocationState.fromValue(state);
    }

    /**
     * <p>
     * The Dedicated Host's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AllocationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateString}.
     * </p>
     * 
     * @return The Dedicated Host's state.
     * @see AllocationState
     */
    public String stateString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoPlacementString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availableCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hostId());
        hashCode = 31 * hashCode + Objects.hashCode(hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hostReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(stateString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host) obj;
        return Objects.equals(autoPlacementString(), other.autoPlacementString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availableCapacity(), other.availableCapacity())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(hostId(), other.hostId())
                && Objects.equals(hostProperties(), other.hostProperties())
                && Objects.equals(hostReservationId(), other.hostReservationId())
                && Objects.equals(instances(), other.instances()) && Objects.equals(stateString(), other.stateString());
    }

    @Override
    public String toString() {
        return ToString.builder("Host").add("AutoPlacement", autoPlacementString()).add("AvailabilityZone", availabilityZone())
                .add("AvailableCapacity", availableCapacity()).add("ClientToken", clientToken()).add("HostId", hostId())
                .add("HostProperties", hostProperties()).add("HostReservationId", hostReservationId())
                .add("Instances", instances()).add("State", stateString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoPlacement":
            return Optional.of(clazz.cast(autoPlacementString()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "AvailableCapacity":
            return Optional.of(clazz.cast(availableCapacity()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "HostId":
            return Optional.of(clazz.cast(hostId()));
        case "HostProperties":
            return Optional.of(clazz.cast(hostProperties()));
        case "HostReservationId":
            return Optional.of(clazz.cast(hostReservationId()));
        case "Instances":
            return Optional.of(clazz.cast(instances()));
        case "State":
            return Optional.of(clazz.cast(stateString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Host> {
        /**
         * <p>
         * Whether auto-placement is on or off.
         * </p>
         * 
         * @param autoPlacement
         *        Whether auto-placement is on or off.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(String autoPlacement);

        /**
         * <p>
         * Whether auto-placement is on or off.
         * </p>
         * 
         * @param autoPlacement
         *        Whether auto-placement is on or off.
         * @see AutoPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPlacement
         */
        Builder autoPlacement(AutoPlacement autoPlacement);

        /**
         * <p>
         * The Availability Zone of the Dedicated Host.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of new instances that can be launched onto the Dedicated Host.
         * </p>
         * 
         * @param availableCapacity
         *        The number of new instances that can be launched onto the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCapacity(AvailableCapacity availableCapacity);

        /**
         * <p>
         * The number of new instances that can be launched onto the Dedicated Host.
         * </p>
         * This is a convenience that creates an instance of the {@link AvailableCapacity.Builder} avoiding the need to
         * create one manually via {@link AvailableCapacity#builder()}.
         *
         * When the {@link Consumer} completes, {@link AvailableCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #availableCapacity(AvailableCapacity)}.
         * 
         * @param availableCapacity
         *        a consumer that will call methods on {@link AvailableCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availableCapacity(AvailableCapacity)
         */
        default Builder availableCapacity(Consumer<AvailableCapacity.Builder> availableCapacity) {
            return availableCapacity(AvailableCapacity.builder().apply(availableCapacity).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more information, see
         * <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Dedicated Host.
         * </p>
         * 
         * @param hostId
         *        The ID of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostId(String hostId);

        /**
         * <p>
         * The hardware specifications of the Dedicated Host.
         * </p>
         * 
         * @param hostProperties
         *        The hardware specifications of the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostProperties(HostProperties hostProperties);

        /**
         * <p>
         * The hardware specifications of the Dedicated Host.
         * </p>
         * This is a convenience that creates an instance of the {@link HostProperties.Builder} avoiding the need to
         * create one manually via {@link HostProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link HostProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #hostProperties(HostProperties)}.
         * 
         * @param hostProperties
         *        a consumer that will call methods on {@link HostProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostProperties(HostProperties)
         */
        default Builder hostProperties(Consumer<HostProperties.Builder> hostProperties) {
            return hostProperties(HostProperties.builder().apply(hostProperties).build());
        }

        /**
         * <p>
         * The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated Host
         * doesn't have an associated reservation.
         * </p>
         * 
         * @param hostReservationId
         *        The reservation ID of the Dedicated Host. This returns a <code>null</code> response if the Dedicated
         *        Host doesn't have an associated reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostReservationId(String hostReservationId);

        /**
         * <p>
         * The IDs and instance type that are currently running on the Dedicated Host.
         * </p>
         * 
         * @param instances
         *        The IDs and instance type that are currently running on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<HostInstance> instances);

        /**
         * <p>
         * The IDs and instance type that are currently running on the Dedicated Host.
         * </p>
         * 
         * @param instances
         *        The IDs and instance type that are currently running on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(HostInstance... instances);

        /**
         * <p>
         * The Dedicated Host's state.
         * </p>
         * 
         * @param state
         *        The Dedicated Host's state.
         * @see AllocationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationState
         */
        Builder state(String state);

        /**
         * <p>
         * The Dedicated Host's state.
         * </p>
         * 
         * @param state
         *        The Dedicated Host's state.
         * @see AllocationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AllocationState
         */
        Builder state(AllocationState state);
    }

    static final class BuilderImpl implements Builder {
        private String autoPlacement;

        private String availabilityZone;

        private AvailableCapacity availableCapacity;

        private String clientToken;

        private String hostId;

        private HostProperties hostProperties;

        private String hostReservationId;

        private List<HostInstance> instances;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            autoPlacement(model.autoPlacement);
            availabilityZone(model.availabilityZone);
            availableCapacity(model.availableCapacity);
            clientToken(model.clientToken);
            hostId(model.hostId);
            hostProperties(model.hostProperties);
            hostReservationId(model.hostReservationId);
            instances(model.instances);
            state(model.state);
        }

        public final String getAutoPlacement() {
            return autoPlacement;
        }

        @Override
        public final Builder autoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
            return this;
        }

        @Override
        public final Builder autoPlacement(AutoPlacement autoPlacement) {
            this.autoPlacement(autoPlacement.toString());
            return this;
        }

        public final void setAutoPlacement(String autoPlacement) {
            this.autoPlacement = autoPlacement;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final AvailableCapacity.Builder getAvailableCapacity() {
            return availableCapacity != null ? availableCapacity.toBuilder() : null;
        }

        @Override
        public final Builder availableCapacity(AvailableCapacity availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(AvailableCapacity.BuilderImpl availableCapacity) {
            this.availableCapacity = availableCapacity != null ? availableCapacity.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getHostId() {
            return hostId;
        }

        @Override
        public final Builder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        public final void setHostId(String hostId) {
            this.hostId = hostId;
        }

        public final HostProperties.Builder getHostProperties() {
            return hostProperties != null ? hostProperties.toBuilder() : null;
        }

        @Override
        public final Builder hostProperties(HostProperties hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final void setHostProperties(HostProperties.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        public final String getHostReservationId() {
            return hostReservationId;
        }

        @Override
        public final Builder hostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
            return this;
        }

        public final void setHostReservationId(String hostReservationId) {
            this.hostReservationId = hostReservationId;
        }

        public final Collection<HostInstance.Builder> getInstances() {
            return instances != null ? instances.stream().map(HostInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<HostInstance> instances) {
            this.instances = HostInstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(HostInstance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<HostInstance.BuilderImpl> instances) {
            this.instances = HostInstanceListCopier.copyFromBuilder(instances);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AllocationState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public Host build() {
            return new Host(this);
        }
    }
}
