/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportVolume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportVolumeRequest extends EC2Request implements
        ToCopyableBuilder<ImportVolumeRequest.Builder, ImportVolumeRequest> {
    private final String availabilityZone;

    private final String description;

    private final DiskImageDetail image;

    private final VolumeDetail volume;

    private ImportVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.description = builder.description;
        this.image = builder.image;
        this.volume = builder.volume;
    }

    /**
     * <p>
     * The Availability Zone for the resulting EBS volume.
     * </p>
     * 
     * @return The Availability Zone for the resulting EBS volume.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * A description of the volume.
     * </p>
     * 
     * @return A description of the volume.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The disk image.
     * </p>
     * 
     * @return The disk image.
     */
    public DiskImageDetail image() {
        return image;
    }

    /**
     * <p>
     * The volume size.
     * </p>
     * 
     * @return The volume size.
     */
    public VolumeDetail volume() {
        return volume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(volume());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeRequest)) {
            return false;
        }
        ImportVolumeRequest other = (ImportVolumeRequest) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(description(), other.description())
                && Objects.equals(image(), other.image()) && Objects.equals(volume(), other.volume());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportVolumeRequest").add("AvailabilityZone", availabilityZone())
                .add("Description", description()).add("Image", image()).add("Volume", volume()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Image":
            return Optional.of(clazz.cast(image()));
        case "Volume":
            return Optional.of(clazz.cast(volume()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ImportVolumeRequest> {
        /**
         * <p>
         * The Availability Zone for the resulting EBS volume.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the resulting EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * A description of the volume.
         * </p>
         * 
         * @param description
         *        A description of the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The disk image.
         * </p>
         * 
         * @param image
         *        The disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(DiskImageDetail image);

        /**
         * <p>
         * The disk image.
         * </p>
         * This is a convenience that creates an instance of the {@link DiskImageDetail.Builder} avoiding the need to
         * create one manually via {@link DiskImageDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link DiskImageDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #image(DiskImageDetail)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link DiskImageDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(DiskImageDetail)
         */
        default Builder image(Consumer<DiskImageDetail.Builder> image) {
            return image(DiskImageDetail.builder().apply(image).build());
        }

        /**
         * <p>
         * The volume size.
         * </p>
         * 
         * @param volume
         *        The volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volume(VolumeDetail volume);

        /**
         * <p>
         * The volume size.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeDetail.Builder} avoiding the need to
         * create one manually via {@link VolumeDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #volume(VolumeDetail)}.
         * 
         * @param volume
         *        a consumer that will call methods on {@link VolumeDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volume(VolumeDetail)
         */
        default Builder volume(Consumer<VolumeDetail.Builder> volume) {
            return volume(VolumeDetail.builder().apply(volume).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String availabilityZone;

        private String description;

        private DiskImageDetail image;

        private VolumeDetail volume;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeRequest model) {
            availabilityZone(model.availabilityZone);
            description(model.description);
            image(model.image);
            volume(model.volume);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DiskImageDetail.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(DiskImageDetail image) {
            this.image = image;
            return this;
        }

        public final void setImage(DiskImageDetail.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        public final VolumeDetail.Builder getVolume() {
            return volume != null ? volume.toBuilder() : null;
        }

        @Override
        public final Builder volume(VolumeDetail volume) {
            this.volume = volume;
            return this;
        }

        public final void setVolume(VolumeDetail.BuilderImpl volume) {
            this.volume = volume != null ? volume.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportVolumeRequest build() {
            return new ImportVolumeRequest(this);
        }
    }
}
