/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the monitoring of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceMonitoring implements ToCopyableBuilder<InstanceMonitoring.Builder, InstanceMonitoring> {
    private final String instanceId;

    private final Monitoring monitoring;

    private InstanceMonitoring(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.monitoring = builder.monitoring;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public Monitoring monitoring() {
        return monitoring;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMonitoring)) {
            return false;
        }
        InstanceMonitoring other = (InstanceMonitoring) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(monitoring(), other.monitoring());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceMonitoring").add("InstanceId", instanceId()).add("Monitoring", monitoring()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Monitoring":
            return Optional.of(clazz.cast(monitoring()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceMonitoring> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Monitoring monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Monitoring.Builder} avoiding the need to create
         * one manually via {@link Monitoring#builder()}.
         *
         * When the {@link Consumer} completes, {@link Monitoring.Builder#build()} is called immediately and its result
         * is passed to {@link #monitoring(Monitoring)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link Monitoring.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(Monitoring)
         */
        default Builder monitoring(Consumer<Monitoring.Builder> monitoring) {
            return monitoring(Monitoring.builder().apply(monitoring).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private Monitoring monitoring;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMonitoring model) {
            instanceId(model.instanceId);
            monitoring(model.monitoring);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Monitoring.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Monitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public InstanceMonitoring build() {
            return new InstanceMonitoring(this);
        }
    }
}
