/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceNetworkInterface implements ToCopyableBuilder<InstanceNetworkInterface.Builder, InstanceNetworkInterface> {
    private final InstanceNetworkInterfaceAssociation association;

    private final InstanceNetworkInterfaceAttachment attachment;

    private final String description;

    private final List<GroupIdentifier> groups;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String macAddress;

    private final String networkInterfaceId;

    private final String ownerId;

    private final String privateDnsName;

    private final String privateIpAddress;

    private final List<InstancePrivateIpAddress> privateIpAddresses;

    private final Boolean sourceDestCheck;

    private final String status;

    private final String subnetId;

    private final String vpcId;

    private InstanceNetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The association information for an Elastic IPv4 associated with the network interface.
     * </p>
     * 
     * @return The association information for an Elastic IPv4 associated with the network interface.
     */
    public InstanceNetworkInterfaceAssociation association() {
        return association;
    }

    /**
     * <p>
     * The network interface attachment.
     * </p>
     * 
     * @return The network interface attachment.
     */
    public InstanceNetworkInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * One or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security groups.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * One or more IPv6 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more IPv6 addresses associated with the network interface.
     */
    public List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The MAC address.
     * </p>
     * 
     * @return The MAC address.
     */
    public String macAddress() {
        return macAddress;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The ID of the AWS account that created the network interface.
     * </p>
     * 
     * @return The ID of the AWS account that created the network interface.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The private DNS name.
     * </p>
     * 
     * @return The private DNS name.
     */
    public String privateDnsName() {
        return privateDnsName;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * One or more private IPv4 addresses associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more private IPv4 addresses associated with the network interface.
     */
    public List<InstancePrivateIpAddress> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * Indicates whether to validate network traffic to or from this network interface.
     * </p>
     * 
     * @return Indicates whether to validate network traffic to or from this network interface.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the network interface.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkInterfaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of the network interface.
     * @see NetworkInterfaceStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(association());
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterface)) {
            return false;
        }
        InstanceNetworkInterface other = (InstanceNetworkInterface) obj;
        return Objects.equals(association(), other.association()) && Objects.equals(attachment(), other.attachment())
                && Objects.equals(description(), other.description()) && Objects.equals(groups(), other.groups())
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(macAddress(), other.macAddress())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(privateDnsName(), other.privateDnsName())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(statusString(), other.statusString()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceNetworkInterface").add("Association", association()).add("Attachment", attachment())
                .add("Description", description()).add("Groups", groups()).add("Ipv6Addresses", ipv6Addresses())
                .add("MacAddress", macAddress()).add("NetworkInterfaceId", networkInterfaceId()).add("OwnerId", ownerId())
                .add("PrivateDnsName", privateDnsName()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", privateIpAddresses()).add("SourceDestCheck", sourceDestCheck())
                .add("Status", statusString()).add("SubnetId", subnetId()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.of(clazz.cast(association()));
        case "Attachment":
            return Optional.of(clazz.cast(attachment()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Groups":
            return Optional.of(clazz.cast(groups()));
        case "Ipv6Addresses":
            return Optional.of(clazz.cast(ipv6Addresses()));
        case "MacAddress":
            return Optional.of(clazz.cast(macAddress()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "OwnerId":
            return Optional.of(clazz.cast(ownerId()));
        case "PrivateDnsName":
            return Optional.of(clazz.cast(privateDnsName()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.of(clazz.cast(privateIpAddresses()));
        case "SourceDestCheck":
            return Optional.of(clazz.cast(sourceDestCheck()));
        case "Status":
            return Optional.of(clazz.cast(statusString()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceNetworkInterface> {
        /**
         * <p>
         * The association information for an Elastic IPv4 associated with the network interface.
         * </p>
         * 
         * @param association
         *        The association information for an Elastic IPv4 associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(InstanceNetworkInterfaceAssociation association);

        /**
         * <p>
         * The association information for an Elastic IPv4 associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceNetworkInterfaceAssociation.Builder}
         * avoiding the need to create one manually via {@link InstanceNetworkInterfaceAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceNetworkInterfaceAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(InstanceNetworkInterfaceAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link InstanceNetworkInterfaceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(InstanceNetworkInterfaceAssociation)
         */
        default Builder association(Consumer<InstanceNetworkInterfaceAssociation.Builder> association) {
            return association(InstanceNetworkInterfaceAssociation.builder().apply(association).build());
        }

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * 
         * @param attachment
         *        The network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(InstanceNetworkInterfaceAttachment attachment);

        /**
         * <p>
         * The network interface attachment.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceNetworkInterfaceAttachment.Builder}
         * avoiding the need to create one manually via {@link InstanceNetworkInterfaceAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceNetworkInterfaceAttachment.Builder#build()} is called
         * immediately and its result is passed to {@link #attachment(InstanceNetworkInterfaceAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link InstanceNetworkInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(InstanceNetworkInterfaceAttachment)
         */
        default Builder attachment(Consumer<InstanceNetworkInterfaceAttachment.Builder> attachment) {
            return attachment(InstanceNetworkInterfaceAttachment.builder().apply(attachment).build());
        }

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * One or more security groups.
         * </p>
         * 
         * @param groups
         *        One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * One or more security groups.
         * </p>
         * 
         * @param groups
         *        One or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * One or more IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * One or more IPv6 addresses associated with the network interface.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more IPv6 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The MAC address.
         * </p>
         * 
         * @param macAddress
         *        The MAC address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The ID of the AWS account that created the network interface.
         * </p>
         * 
         * @param ownerId
         *        The ID of the AWS account that created the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The private DNS name.
         * </p>
         * 
         * @param privateDnsName
         *        The private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsName(String privateDnsName);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * One or more private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses associated with the network interface.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(InstancePrivateIpAddress... privateIpAddresses);

        /**
         * <p>
         * Indicates whether to validate network traffic to or from this network interface.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether to validate network traffic to or from this network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the network interface.
         * </p>
         * 
         * @param status
         *        The status of the network interface.
         * @see NetworkInterfaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceStatus
         */
        Builder status(NetworkInterfaceStatus status);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private InstanceNetworkInterfaceAssociation association;

        private InstanceNetworkInterfaceAttachment attachment;

        private String description;

        private List<GroupIdentifier> groups;

        private List<InstanceIpv6Address> ipv6Addresses;

        private String macAddress;

        private String networkInterfaceId;

        private String ownerId;

        private String privateDnsName;

        private String privateIpAddress;

        private List<InstancePrivateIpAddress> privateIpAddresses;

        private Boolean sourceDestCheck;

        private String status;

        private String subnetId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterface model) {
            association(model.association);
            attachment(model.attachment);
            description(model.description);
            groups(model.groups);
            ipv6Addresses(model.ipv6Addresses);
            macAddress(model.macAddress);
            networkInterfaceId(model.networkInterfaceId);
            ownerId(model.ownerId);
            privateDnsName(model.privateDnsName);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            sourceDestCheck(model.sourceDestCheck);
            status(model.status);
            subnetId(model.subnetId);
            vpcId(model.vpcId);
        }

        public final InstanceNetworkInterfaceAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        @Override
        public final Builder association(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(InstanceNetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final InstanceNetworkInterfaceAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(InstanceNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(InstanceNetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<InstanceIpv6Address.Builder> getIpv6Addresses() {
            return ipv6Addresses != null ? ipv6Addresses.stream().map(InstanceIpv6Address::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrivateDnsName() {
            return privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<InstancePrivateIpAddress.Builder> getPrivateIpAddresses() {
            return privateIpAddresses != null ? privateIpAddresses.stream().map(InstancePrivateIpAddress::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstancePrivateIpAddress... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<InstancePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public InstanceNetworkInterface build() {
            return new InstanceNetworkInterface(this);
        }
    }
}
