/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance state change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceStateChange implements ToCopyableBuilder<InstanceStateChange.Builder, InstanceStateChange> {
    private final InstanceState currentState;

    private final String instanceId;

    private final InstanceState previousState;

    private InstanceStateChange(BuilderImpl builder) {
        this.currentState = builder.currentState;
        this.instanceId = builder.instanceId;
        this.previousState = builder.previousState;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * 
     * @return The current state of the instance.
     */
    public InstanceState currentState() {
        return currentState;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The previous state of the instance.
     * </p>
     * 
     * @return The previous state of the instance.
     */
    public InstanceState previousState() {
        return previousState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentState());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(previousState());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStateChange)) {
            return false;
        }
        InstanceStateChange other = (InstanceStateChange) obj;
        return Objects.equals(currentState(), other.currentState()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(previousState(), other.previousState());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceStateChange").add("CurrentState", currentState()).add("InstanceId", instanceId())
                .add("PreviousState", previousState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentState":
            return Optional.of(clazz.cast(currentState()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "PreviousState":
            return Optional.of(clazz.cast(previousState()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceStateChange> {
        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param currentState
         *        The current state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentState(InstanceState currentState);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceState.Builder} avoiding the need to
         * create one manually via {@link InstanceState#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #currentState(InstanceState)}.
         * 
         * @param currentState
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentState(InstanceState)
         */
        default Builder currentState(Consumer<InstanceState.Builder> currentState) {
            return currentState(InstanceState.builder().apply(currentState).build());
        }

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The previous state of the instance.
         * </p>
         * 
         * @param previousState
         *        The previous state of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousState(InstanceState previousState);

        /**
         * <p>
         * The previous state of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceState.Builder} avoiding the need to
         * create one manually via {@link InstanceState#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceState.Builder#build()} is called immediately and its
         * result is passed to {@link #previousState(InstanceState)}.
         * 
         * @param previousState
         *        a consumer that will call methods on {@link InstanceState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previousState(InstanceState)
         */
        default Builder previousState(Consumer<InstanceState.Builder> previousState) {
            return previousState(InstanceState.builder().apply(previousState).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InstanceState currentState;

        private String instanceId;

        private InstanceState previousState;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStateChange model) {
            currentState(model.currentState);
            instanceId(model.instanceId);
            previousState(model.previousState);
        }

        public final InstanceState.Builder getCurrentState() {
            return currentState != null ? currentState.toBuilder() : null;
        }

        @Override
        public final Builder currentState(InstanceState currentState) {
            this.currentState = currentState;
            return this;
        }

        public final void setCurrentState(InstanceState.BuilderImpl currentState) {
            this.currentState = currentState != null ? currentState.build() : null;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final InstanceState.Builder getPreviousState() {
            return previousState != null ? previousState.toBuilder() : null;
        }

        @Override
        public final Builder previousState(InstanceState previousState) {
            this.previousState = previousState;
            return this;
        }

        public final void setPreviousState(InstanceState.BuilderImpl previousState) {
            this.previousState = previousState != null ? previousState.build() : null;
        }

        @Override
        public InstanceStateChange build() {
            return new InstanceStateChange(this);
        }
    }
}
