/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Classic Load Balancers and target groups to attach to a Spot fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class LoadBalancersConfig implements ToCopyableBuilder<LoadBalancersConfig.Builder, LoadBalancersConfig> {
    private final ClassicLoadBalancersConfig classicLoadBalancersConfig;

    private final TargetGroupsConfig targetGroupsConfig;

    private LoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancersConfig = builder.classicLoadBalancersConfig;
        this.targetGroupsConfig = builder.targetGroupsConfig;
    }

    /**
     * <p>
     * The Classic Load Balancers.
     * </p>
     * 
     * @return The Classic Load Balancers.
     */
    public ClassicLoadBalancersConfig classicLoadBalancersConfig() {
        return classicLoadBalancersConfig;
    }

    /**
     * <p>
     * The target groups.
     * </p>
     * 
     * @return The target groups.
     */
    public TargetGroupsConfig targetGroupsConfig() {
        return targetGroupsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(classicLoadBalancersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupsConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancersConfig)) {
            return false;
        }
        LoadBalancersConfig other = (LoadBalancersConfig) obj;
        return Objects.equals(classicLoadBalancersConfig(), other.classicLoadBalancersConfig())
                && Objects.equals(targetGroupsConfig(), other.targetGroupsConfig());
    }

    @Override
    public String toString() {
        return ToString.builder("LoadBalancersConfig").add("ClassicLoadBalancersConfig", classicLoadBalancersConfig())
                .add("TargetGroupsConfig", targetGroupsConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClassicLoadBalancersConfig":
            return Optional.of(clazz.cast(classicLoadBalancersConfig()));
        case "TargetGroupsConfig":
            return Optional.of(clazz.cast(targetGroupsConfig()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LoadBalancersConfig> {
        /**
         * <p>
         * The Classic Load Balancers.
         * </p>
         * 
         * @param classicLoadBalancersConfig
         *        The Classic Load Balancers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLoadBalancersConfig(ClassicLoadBalancersConfig classicLoadBalancersConfig);

        /**
         * <p>
         * The Classic Load Balancers.
         * </p>
         * This is a convenience that creates an instance of the {@link ClassicLoadBalancersConfig.Builder} avoiding the
         * need to create one manually via {@link ClassicLoadBalancersConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClassicLoadBalancersConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #classicLoadBalancersConfig(ClassicLoadBalancersConfig)}.
         * 
         * @param classicLoadBalancersConfig
         *        a consumer that will call methods on {@link ClassicLoadBalancersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #classicLoadBalancersConfig(ClassicLoadBalancersConfig)
         */
        default Builder classicLoadBalancersConfig(Consumer<ClassicLoadBalancersConfig.Builder> classicLoadBalancersConfig) {
            return classicLoadBalancersConfig(ClassicLoadBalancersConfig.builder().apply(classicLoadBalancersConfig).build());
        }

        /**
         * <p>
         * The target groups.
         * </p>
         * 
         * @param targetGroupsConfig
         *        The target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupsConfig(TargetGroupsConfig targetGroupsConfig);

        /**
         * <p>
         * The target groups.
         * </p>
         * This is a convenience that creates an instance of the {@link TargetGroupsConfig.Builder} avoiding the need to
         * create one manually via {@link TargetGroupsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TargetGroupsConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #targetGroupsConfig(TargetGroupsConfig)}.
         * 
         * @param targetGroupsConfig
         *        a consumer that will call methods on {@link TargetGroupsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetGroupsConfig(TargetGroupsConfig)
         */
        default Builder targetGroupsConfig(Consumer<TargetGroupsConfig.Builder> targetGroupsConfig) {
            return targetGroupsConfig(TargetGroupsConfig.builder().apply(targetGroupsConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClassicLoadBalancersConfig classicLoadBalancersConfig;

        private TargetGroupsConfig targetGroupsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancersConfig model) {
            classicLoadBalancersConfig(model.classicLoadBalancersConfig);
            targetGroupsConfig(model.targetGroupsConfig);
        }

        public final ClassicLoadBalancersConfig.Builder getClassicLoadBalancersConfig() {
            return classicLoadBalancersConfig != null ? classicLoadBalancersConfig.toBuilder() : null;
        }

        @Override
        public final Builder classicLoadBalancersConfig(ClassicLoadBalancersConfig classicLoadBalancersConfig) {
            this.classicLoadBalancersConfig = classicLoadBalancersConfig;
            return this;
        }

        public final void setClassicLoadBalancersConfig(ClassicLoadBalancersConfig.BuilderImpl classicLoadBalancersConfig) {
            this.classicLoadBalancersConfig = classicLoadBalancersConfig != null ? classicLoadBalancersConfig.build() : null;
        }

        public final TargetGroupsConfig.Builder getTargetGroupsConfig() {
            return targetGroupsConfig != null ? targetGroupsConfig.toBuilder() : null;
        }

        @Override
        public final Builder targetGroupsConfig(TargetGroupsConfig targetGroupsConfig) {
            this.targetGroupsConfig = targetGroupsConfig;
            return this;
        }

        public final void setTargetGroupsConfig(TargetGroupsConfig.BuilderImpl targetGroupsConfig) {
            this.targetGroupsConfig = targetGroupsConfig != null ? targetGroupsConfig.build() : null;
        }

        @Override
        public LoadBalancersConfig build() {
            return new LoadBalancersConfig(this);
        }
    }
}
