/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ModifyReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyReservedInstancesResponse extends EC2Response implements
        ToCopyableBuilder<ModifyReservedInstancesResponse.Builder, ModifyReservedInstancesResponse> {
    private final String reservedInstancesModificationId;

    private ModifyReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesModificationId = builder.reservedInstancesModificationId;
    }

    /**
     * <p>
     * The ID for the modification.
     * </p>
     * 
     * @return The ID for the modification.
     */
    public String reservedInstancesModificationId() {
        return reservedInstancesModificationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesModificationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesResponse)) {
            return false;
        }
        ModifyReservedInstancesResponse other = (ModifyReservedInstancesResponse) obj;
        return Objects.equals(reservedInstancesModificationId(), other.reservedInstancesModificationId());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyReservedInstancesResponse")
                .add("ReservedInstancesModificationId", reservedInstancesModificationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesModificationId":
            return Optional.of(clazz.cast(reservedInstancesModificationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, ModifyReservedInstancesResponse> {
        /**
         * <p>
         * The ID for the modification.
         * </p>
         * 
         * @param reservedInstancesModificationId
         *        The ID for the modification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesModificationId(String reservedInstancesModificationId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String reservedInstancesModificationId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReservedInstancesResponse model) {
            reservedInstancesModificationId(model.reservedInstancesModificationId);
        }

        public final String getReservedInstancesModificationId() {
            return reservedInstancesModificationId;
        }

        @Override
        public final Builder reservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
            return this;
        }

        public final void setReservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
        }

        @Override
        public ModifyReservedInstancesResponse build() {
            return new ModifyReservedInstancesResponse(this);
        }
    }
}
