/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ModifySubnetAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifySubnetAttributeRequest extends EC2Request implements
        ToCopyableBuilder<ModifySubnetAttributeRequest.Builder, ModifySubnetAttributeRequest> {
    private final Boolean assignIpv6AddressOnCreation;

    private final Boolean mapPublicIpOnLaunch;

    private final String subnetId;

    private ModifySubnetAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.assignIpv6AddressOnCreation = builder.assignIpv6AddressOnCreation;
        this.mapPublicIpOnLaunch = builder.mapPublicIpOnLaunch;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be assigned
     * an IPv6 address. This includes a network interface that's created when launching an instance into the subnet (the
     * instance therefore receives an IPv6 address).
     * </p>
     * <p>
     * If you enable the IPv6 addressing feature for your subnet, your network interface or instance only receives an
     * IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon EC2 API.
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be
     *         assigned an IPv6 address. This includes a network interface that's created when launching an instance
     *         into the subnet (the instance therefore receives an IPv6 address). </p>
     *         <p>
     *         If you enable the IPv6 addressing feature for your subnet, your network interface or instance only
     *         receives an IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon EC2
     *         API.
     */
    public Boolean assignIpv6AddressOnCreation() {
        return assignIpv6AddressOnCreation;
    }

    /**
     * <p>
     * Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be assigned
     * a public IPv4 address. This includes a network interface that's created when launching an instance into the
     * subnet (the instance therefore receives a public IPv4 address).
     * </p>
     * 
     * @return Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be
     *         assigned a public IPv4 address. This includes a network interface that's created when launching an
     *         instance into the subnet (the instance therefore receives a public IPv4 address).
     */
    public Boolean mapPublicIpOnLaunch() {
        return mapPublicIpOnLaunch;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assignIpv6AddressOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(mapPublicIpOnLaunch());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySubnetAttributeRequest)) {
            return false;
        }
        ModifySubnetAttributeRequest other = (ModifySubnetAttributeRequest) obj;
        return Objects.equals(assignIpv6AddressOnCreation(), other.assignIpv6AddressOnCreation())
                && Objects.equals(mapPublicIpOnLaunch(), other.mapPublicIpOnLaunch())
                && Objects.equals(subnetId(), other.subnetId());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifySubnetAttributeRequest").add("AssignIpv6AddressOnCreation", assignIpv6AddressOnCreation())
                .add("MapPublicIpOnLaunch", mapPublicIpOnLaunch()).add("SubnetId", subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssignIpv6AddressOnCreation":
            return Optional.of(clazz.cast(assignIpv6AddressOnCreation()));
        case "MapPublicIpOnLaunch":
            return Optional.of(clazz.cast(mapPublicIpOnLaunch()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifySubnetAttributeRequest> {
        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be
         * assigned an IPv6 address. This includes a network interface that's created when launching an instance into
         * the subnet (the instance therefore receives an IPv6 address).
         * </p>
         * <p>
         * If you enable the IPv6 addressing feature for your subnet, your network interface or instance only receives
         * an IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon EC2 API.
         * </p>
         * 
         * @param assignIpv6AddressOnCreation
         *        Specify <code>true</code> to indicate that network interfaces created in the specified subnet should
         *        be assigned an IPv6 address. This includes a network interface that's created when launching an
         *        instance into the subnet (the instance therefore receives an IPv6 address). </p>
         *        <p>
         *        If you enable the IPv6 addressing feature for your subnet, your network interface or instance only
         *        receives an IPv6 address if it's created using version <code>2016-11-15</code> or later of the Amazon
         *        EC2 API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation);

        /**
         * <p>
         * Specify <code>true</code> to indicate that network interfaces created in the specified subnet should be
         * assigned a public IPv4 address. This includes a network interface that's created when launching an instance
         * into the subnet (the instance therefore receives a public IPv4 address).
         * </p>
         * 
         * @param mapPublicIpOnLaunch
         *        Specify <code>true</code> to indicate that network interfaces created in the specified subnet should
         *        be assigned a public IPv4 address. This includes a network interface that's created when launching an
         *        instance into the subnet (the instance therefore receives a public IPv4 address).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private Boolean assignIpv6AddressOnCreation;

        private Boolean mapPublicIpOnLaunch;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySubnetAttributeRequest model) {
            assignIpv6AddressOnCreation(model.assignIpv6AddressOnCreation);
            mapPublicIpOnLaunch(model.mapPublicIpOnLaunch);
            subnetId(model.subnetId);
        }

        public final Boolean getAssignIpv6AddressOnCreation() {
            return assignIpv6AddressOnCreation;
        }

        @Override
        public final Builder assignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
            return this;
        }

        public final void setAssignIpv6AddressOnCreation(Boolean assignIpv6AddressOnCreation) {
            this.assignIpv6AddressOnCreation = assignIpv6AddressOnCreation;
        }

        public final Boolean getMapPublicIpOnLaunch() {
            return mapPublicIpOnLaunch;
        }

        @Override
        public final Builder mapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
            return this;
        }

        public final void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
            this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifySubnetAttributeRequest build() {
            return new ModifySubnetAttributeRequest(this);
        }
    }
}
