/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes prefixes for AWS services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PrefixList implements ToCopyableBuilder<PrefixList.Builder, PrefixList> {
    private final List<String> cidrs;

    private final String prefixListId;

    private final String prefixListName;

    private PrefixList(BuilderImpl builder) {
        this.cidrs = builder.cidrs;
        this.prefixListId = builder.prefixListId;
        this.prefixListName = builder.prefixListName;
    }

    /**
     * <p>
     * The IP address range of the AWS service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IP address range of the AWS service.
     */
    public List<String> cidrs() {
        return cidrs;
    }

    /**
     * <p>
     * The ID of the prefix.
     * </p>
     * 
     * @return The ID of the prefix.
     */
    public String prefixListId() {
        return prefixListId;
    }

    /**
     * <p>
     * The name of the prefix.
     * </p>
     * 
     * @return The name of the prefix.
     */
    public String prefixListName() {
        return prefixListName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrs());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(prefixListName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixList)) {
            return false;
        }
        PrefixList other = (PrefixList) obj;
        return Objects.equals(cidrs(), other.cidrs()) && Objects.equals(prefixListId(), other.prefixListId())
                && Objects.equals(prefixListName(), other.prefixListName());
    }

    @Override
    public String toString() {
        return ToString.builder("PrefixList").add("Cidrs", cidrs()).add("PrefixListId", prefixListId())
                .add("PrefixListName", prefixListName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cidrs":
            return Optional.of(clazz.cast(cidrs()));
        case "PrefixListId":
            return Optional.of(clazz.cast(prefixListId()));
        case "PrefixListName":
            return Optional.of(clazz.cast(prefixListName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, PrefixList> {
        /**
         * <p>
         * The IP address range of the AWS service.
         * </p>
         * 
         * @param cidrs
         *        The IP address range of the AWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(Collection<String> cidrs);

        /**
         * <p>
         * The IP address range of the AWS service.
         * </p>
         * 
         * @param cidrs
         *        The IP address range of the AWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrs(String... cidrs);

        /**
         * <p>
         * The ID of the prefix.
         * </p>
         * 
         * @param prefixListId
         *        The ID of the prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListId(String prefixListId);

        /**
         * <p>
         * The name of the prefix.
         * </p>
         * 
         * @param prefixListName
         *        The name of the prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListName(String prefixListName);
    }

    static final class BuilderImpl implements Builder {
        private List<String> cidrs;

        private String prefixListId;

        private String prefixListName;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixList model) {
            cidrs(model.cidrs);
            prefixListId(model.prefixListId);
            prefixListName(model.prefixListName);
        }

        public final Collection<String> getCidrs() {
            return cidrs;
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String... cidrs) {
            cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = ValueStringListCopier.copy(cidrs);
        }

        public final String getPrefixListId() {
            return prefixListId;
        }

        @Override
        public final Builder prefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
            return this;
        }

        public final void setPrefixListId(String prefixListId) {
            this.prefixListId = prefixListId;
        }

        public final String getPrefixListName() {
            return prefixListName;
        }

        @Override
        public final Builder prefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        public final void setPrefixListName(String prefixListName) {
            this.prefixListName = prefixListName;
        }

        @Override
        public PrefixList build() {
            return new PrefixList(this);
        }
    }
}
