/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of PurchaseReservedInstancesOffering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PurchaseReservedInstancesOfferingResponse extends EC2Response implements
        ToCopyableBuilder<PurchaseReservedInstancesOfferingResponse.Builder, PurchaseReservedInstancesOfferingResponse> {
    private final String reservedInstancesId;

    private PurchaseReservedInstancesOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesId = builder.reservedInstancesId;
    }

    /**
     * <p>
     * The IDs of the purchased Reserved Instances.
     * </p>
     * 
     * @return The IDs of the purchased Reserved Instances.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedInstancesOfferingResponse)) {
            return false;
        }
        PurchaseReservedInstancesOfferingResponse other = (PurchaseReservedInstancesOfferingResponse) obj;
        return Objects.equals(reservedInstancesId(), other.reservedInstancesId());
    }

    @Override
    public String toString() {
        return ToString.builder("PurchaseReservedInstancesOfferingResponse").add("ReservedInstancesId", reservedInstancesId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesId":
            return Optional.of(clazz.cast(reservedInstancesId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, PurchaseReservedInstancesOfferingResponse> {
        /**
         * <p>
         * The IDs of the purchased Reserved Instances.
         * </p>
         * 
         * @param reservedInstancesId
         *        The IDs of the purchased Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String reservedInstancesId;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedInstancesOfferingResponse model) {
            reservedInstancesId(model.reservedInstancesId);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        @Override
        public PurchaseReservedInstancesOfferingResponse build() {
            return new PurchaseReservedInstancesOfferingResponse(this);
        }
    }
}
