/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RunInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RunInstancesRequest extends EC2Request implements
        ToCopyableBuilder<RunInstancesRequest.Builder, RunInstancesRequest> {
    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String imageId;

    private final String instanceType;

    private final Integer ipv6AddressCount;

    private final List<InstanceIpv6Address> ipv6Addresses;

    private final String kernelId;

    private final String keyName;

    private final Integer maxCount;

    private final Integer minCount;

    private final Boolean monitoring;

    private final Placement placement;

    private final String ramdiskId;

    private final List<String> securityGroupIds;

    private final List<String> securityGroups;

    private final String subnetId;

    private final String userData;

    private final String additionalInfo;

    private final String clientToken;

    private final Boolean disableApiTermination;

    private final Boolean ebsOptimized;

    private final IamInstanceProfileSpecification iamInstanceProfile;

    private final String instanceInitiatedShutdownBehavior;

    private final List<InstanceNetworkInterfaceSpecification> networkInterfaces;

    private final String privateIpAddress;

    private final List<ElasticGpuSpecification> elasticGpuSpecification;

    private final List<TagSpecification> tagSpecifications;

    private RunInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.maxCount = builder.maxCount;
        this.minCount = builder.minCount;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramdiskId = builder.ramdiskId;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
        this.additionalInfo = builder.additionalInfo;
        this.clientToken = builder.clientToken;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.networkInterfaces = builder.networkInterfaces;
        this.privateIpAddress = builder.privateIpAddress;
        this.elasticGpuSpecification = builder.elasticGpuSpecification;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * <p>
     * One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This is
     * because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank
     * and its encryption status is used for the volume encryption status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value.
     *         This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume,
     *         it is not blank and its encryption status is used for the volume encryption status.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The ID of the AMI, which you can get by calling <a>DescribeImages</a>.
     * </p>
     * 
     * @return The ID of the AMI, which you can get by calling <a>DescribeImages</a>.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Default: <code>m1.small</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *         <p>
     *         Default: <code>m1.small</code>
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Default: <code>m1.small</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeString}.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *         <p>
     *         Default: <code>m1.small</code>
     * @see InstanceType
     */
    public String instanceTypeString() {
        return instanceType;
    }

    /**
     * <p>
     * [EC2-VPC] A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6
     * addresses from the range of your subnet. You cannot specify this option and the option to assign specific IPv6
     * addresses in the same request. You can specify this option if you've specified a minimum number of instances to
     * launch.
     * </p>
     * 
     * @return [EC2-VPC] A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses
     *         the IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign
     *         specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum
     *         number of instances to launch.
     */
    public Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * <p>
     * [EC2-VPC] Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network
     * interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the same
     * request. You cannot specify this option if you've specified a minimum number of instances to launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-VPC] Specify one or more IPv6 addresses from the range of the subnet to associate with the primary
     *         network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in
     *         the same request. You cannot specify this option if you've specified a minimum number of instances to
     *         launch.
     */
    public List<InstanceIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the kernel.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair. You can create a key pair using <a>CreateKeyPair</a> or <a>ImportKeyPair</a>.
     * </p>
     * <important>
     * <p>
     * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is configured
     * to allow users another way to log in.
     * </p>
     * </important>
     * 
     * @return The name of the key pair. You can create a key pair using <a>CreateKeyPair</a> or
     *         <a>ImportKeyPair</a>.</p> <important>
     *         <p>
     *         If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
     *         configured to allow users another way to log in.
     *         </p>
     */
    public String keyName() {
        return keyName;
    }

    /**
     * <p>
     * The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the target
     * Availability Zone, Amazon EC2 launches the largest possible number of instances above <code>MinCount</code>.
     * </p>
     * <p>
     * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     * information about the default limits, and how to request an increase, see <a
     * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in
     * Amazon EC2</a> in the Amazon EC2 FAQ.
     * </p>
     * 
     * @return The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in
     *         the target Availability Zone, Amazon EC2 launches the largest possible number of instances above
     *         <code>MinCount</code>.</p>
     *         <p>
     *         Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     *         information about the default limits, and how to request an increase, see <a
     *         href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can
     *         I run in Amazon EC2</a> in the Amazon EC2 FAQ.
     */
    public Integer maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2 can
     * launch in the target Availability Zone, Amazon EC2 launches no instances.
     * </p>
     * <p>
     * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     * information about the default limits, and how to request an increase, see <a
     * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I run in
     * Amazon EC2</a> in the Amazon EC2 General FAQ.
     * </p>
     * 
     * @return The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon
     *         EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.</p>
     *         <p>
     *         Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
     *         information about the default limits, and how to request an increase, see <a
     *         href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can
     *         I run in Amazon EC2</a> in the Amazon EC2 General FAQ.
     */
    public Integer minCount() {
        return minCount;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public Boolean monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The placement for the instance.
     * </p>
     * 
     * @return The placement for the instance.
     */
    public Placement placement() {
        return placement;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * <important>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the <i>Amazon
     * Elastic Compute Cloud User Guide</i>.
     * </p>
     * </important>
     * 
     * @return The ID of the RAM disk.</p> <important>
     *         <p>
     *         We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
     *         <i>Amazon Elastic Compute Cloud User Guide</i>.
     *         </p>
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * One or more security group IDs. You can create a security group using <a>CreateSecurityGroup</a>.
     * </p>
     * <p>
     * Default: Amazon EC2 uses the default security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group IDs. You can create a security group using <a>CreateSecurityGroup</a>.</p>
     *         <p>
     *         Default: Amazon EC2 uses the default security group.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security group
     * IDs instead.
     * </p>
     * <p>
     * Default: Amazon EC2 uses the default security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security
     *         group IDs instead.</p>
     *         <p>
     *         Default: Amazon EC2 uses the default security group.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the subnet to launch the instance into.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the subnet to launch the instance into.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The user data to make available to the instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux Instance
     * at Launch</a> (Linux) and <a href=
     * "http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
     * >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you, and
     * you can load the text from a file. Otherwise, you must provide base64-encoded text.
     * </p>
     * 
     * @return The user data to make available to the instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux
     *         Instance at Launch</a> (Linux) and <a href=
     *         "http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
     *         >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed for
     *         you, and you can load the text from a file. Otherwise, you must provide base64-encoded text.
     */
    public String userData() {
        return userData;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public String additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information, see
     * <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * <p>
     * Constraints: Maximum 64 ASCII characters
     * </p>
     * 
     * @return Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.</p>
     *         <p>
     *         Constraints: Maximum 64 ASCII characters
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2 console,
     * CLI, or API; otherwise, you can. To change this attribute to <code>false</code> after launch, use
     * <a>ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
     * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
     *         console, CLI, or API; otherwise, you can. To change this attribute to <code>false</code> after launch,
     *         use <a>ModifyInstanceAttribute</a>. Alternatively, if you set
     *         <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can terminate the instance
     *         by running the shutdown command from the instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput
     * to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance. This
     * optimization isn't available with all instance types. Additional usage charges apply when using an EBS-optimized
     * instance.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
     *         throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
     *         performance. This optimization isn't available with all instance types. Additional usage charges apply
     *         when using an EBS-optimized instance.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The IAM instance profile.
     * </p>
     * 
     * @return The IAM instance profile.
     */
    public IamInstanceProfileSpecification iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(instanceInitiatedShutdownBehavior);
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * <p>
     * Default: <code>stop</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInitiatedShutdownBehavior} will return {@link ShutdownBehavior#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #instanceInitiatedShutdownBehaviorString}.
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).</p>
     *         <p>
     *         Default: <code>stop</code>
     * @see ShutdownBehavior
     */
    public String instanceInitiatedShutdownBehaviorString() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * One or more network interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interfaces.
     */
    public List<InstanceNetworkInterfaceSpecification> networkInterfaces() {
        return networkInterfaces;
    }

    /**
     * <p>
     * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
     * </p>
     * <p>
     * Only one private IP address can be designated as primary. You can't specify this option if you've specified the
     * option to designate a private IP address as the primary IP address in a network interface specification. You
     * cannot specify this option if you're launching more than one instance in the request.
     * </p>
     * 
     * @return [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the
     *         subnet.</p>
     *         <p>
     *         Only one private IP address can be designated as primary. You can't specify this option if you've
     *         specified the option to designate a private IP address as the primary IP address in a network interface
     *         specification. You cannot specify this option if you're launching more than one instance in the request.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * An Elastic GPU to associate with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An Elastic GPU to associate with the instance.
     */
    public List<ElasticGpuSpecification> elasticGpuSpecification() {
        return elasticGpuSpecification;
    }

    /**
     * <p>
     * The tags to apply to the resources during launch. You can tag instances and volumes. The specified tags are
     * applied to all instances or volumes that are created during launch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to apply to the resources during launch. You can tag instances and volumes. The specified tags
     *         are applied to all instances or volumes that are created during launch.
     */
    public List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(minCount());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaces());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(tagSpecifications());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunInstancesRequest)) {
            return false;
        }
        RunInstancesRequest other = (RunInstancesRequest) obj;
        return Objects.equals(blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceTypeString(), other.instanceTypeString())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount())
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(keyName(), other.keyName()) && Objects.equals(maxCount(), other.maxCount())
                && Objects.equals(minCount(), other.minCount()) && Objects.equals(monitoring(), other.monitoring())
                && Objects.equals(placement(), other.placement()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(userData(), other.userData()) && Objects.equals(additionalInfo(), other.additionalInfo())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile())
                && Objects.equals(instanceInitiatedShutdownBehaviorString(), other.instanceInitiatedShutdownBehaviorString())
                && Objects.equals(networkInterfaces(), other.networkInterfaces())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(elasticGpuSpecification(), other.elasticGpuSpecification())
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    @Override
    public String toString() {
        return ToString.builder("RunInstancesRequest").add("BlockDeviceMappings", blockDeviceMappings())
                .add("ImageId", imageId()).add("InstanceType", instanceTypeString()).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", ipv6Addresses()).add("KernelId", kernelId()).add("KeyName", keyName())
                .add("MaxCount", maxCount()).add("MinCount", minCount()).add("Monitoring", monitoring())
                .add("Placement", placement()).add("RamdiskId", ramdiskId()).add("SecurityGroupIds", securityGroupIds())
                .add("SecurityGroups", securityGroups()).add("SubnetId", subnetId()).add("UserData", userData())
                .add("AdditionalInfo", additionalInfo()).add("ClientToken", clientToken())
                .add("DisableApiTermination", disableApiTermination()).add("EbsOptimized", ebsOptimized())
                .add("IamInstanceProfile", iamInstanceProfile())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehaviorString())
                .add("NetworkInterfaces", networkInterfaces()).add("PrivateIpAddress", privateIpAddress())
                .add("ElasticGpuSpecification", elasticGpuSpecification()).add("TagSpecifications", tagSpecifications()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "ImageId":
            return Optional.of(clazz.cast(imageId()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceTypeString()));
        case "Ipv6AddressCount":
            return Optional.of(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.of(clazz.cast(ipv6Addresses()));
        case "KernelId":
            return Optional.of(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        case "MaxCount":
            return Optional.of(clazz.cast(maxCount()));
        case "MinCount":
            return Optional.of(clazz.cast(minCount()));
        case "Monitoring":
            return Optional.of(clazz.cast(monitoring()));
        case "Placement":
            return Optional.of(clazz.cast(placement()));
        case "RamdiskId":
            return Optional.of(clazz.cast(ramdiskId()));
        case "SecurityGroupIds":
            return Optional.of(clazz.cast(securityGroupIds()));
        case "SecurityGroups":
            return Optional.of(clazz.cast(securityGroups()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "UserData":
            return Optional.of(clazz.cast(userData()));
        case "AdditionalInfo":
            return Optional.of(clazz.cast(additionalInfo()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "DisableApiTermination":
            return Optional.of(clazz.cast(disableApiTermination()));
        case "EbsOptimized":
            return Optional.of(clazz.cast(ebsOptimized()));
        case "IamInstanceProfile":
            return Optional.of(clazz.cast(iamInstanceProfile()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.of(clazz.cast(instanceInitiatedShutdownBehaviorString()));
        case "NetworkInterfaces":
            return Optional.of(clazz.cast(networkInterfaces()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        case "ElasticGpuSpecification":
            return Optional.of(clazz.cast(elasticGpuSpecification()));
        case "TagSpecifications":
            return Optional.of(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, RunInstancesRequest> {
        /**
         * <p>
         * One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This
         * is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is
         * not blank and its encryption status is used for the volume encryption status.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries. You can't specify both a snapshot ID and an encryption
         *        value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for
         *        a volume, it is not blank and its encryption status is used for the volume encryption status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries. You can't specify both a snapshot ID and an encryption value. This
         * is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is
         * not blank and its encryption status is used for the volume encryption status.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries. You can't specify both a snapshot ID and an encryption
         *        value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for
         *        a volume, it is not blank and its encryption status is used for the volume encryption status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The ID of the AMI, which you can get by calling <a>DescribeImages</a>.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI, which you can get by calling <a>DescribeImages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * Default: <code>m1.small</code>
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
         *        <p>
         *        Default: <code>m1.small</code>
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * <p>
         * Default: <code>m1.small</code>
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Types</a> in
         *        the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
         *        <p>
         *        Default: <code>m1.small</code>
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * [EC2-VPC] A number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the
         * IPv6 addresses from the range of your subnet. You cannot specify this option and the option to assign
         * specific IPv6 addresses in the same request. You can specify this option if you've specified a minimum number
         * of instances to launch.
         * </p>
         * 
         * @param ipv6AddressCount
         *        [EC2-VPC] A number of IPv6 addresses to associate with the primary network interface. Amazon EC2
         *        chooses the IPv6 addresses from the range of your subnet. You cannot specify this option and the
         *        option to assign specific IPv6 addresses in the same request. You can specify this option if you've
         *        specified a minimum number of instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * [EC2-VPC] Specify one or more IPv6 addresses from the range of the subnet to associate with the primary
         * network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the
         * same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6Addresses
         *        [EC2-VPC] Specify one or more IPv6 addresses from the range of the subnet to associate with the
         *        primary network interface. You cannot specify this option and the option to assign a number of IPv6
         *        addresses in the same request. You cannot specify this option if you've specified a minimum number of
         *        instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses);

        /**
         * <p>
         * [EC2-VPC] Specify one or more IPv6 addresses from the range of the subnet to associate with the primary
         * network interface. You cannot specify this option and the option to assign a number of IPv6 addresses in the
         * same request. You cannot specify this option if you've specified a minimum number of instances to launch.
         * </p>
         * 
         * @param ipv6Addresses
         *        [EC2-VPC] Specify one or more IPv6 addresses from the range of the subnet to associate with the
         *        primary network interface. You cannot specify this option and the option to assign a number of IPv6
         *        addresses in the same request. You cannot specify this option if you've specified a minimum number of
         *        instances to launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * </important>
         * 
         * @param kernelId
         *        The ID of the kernel.</p> <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair. You can create a key pair using <a>CreateKeyPair</a> or <a>ImportKeyPair</a>.
         * </p>
         * <important>
         * <p>
         * If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         * configured to allow users another way to log in.
         * </p>
         * </important>
         * 
         * @param keyName
         *        The name of the key pair. You can create a key pair using <a>CreateKeyPair</a> or
         *        <a>ImportKeyPair</a>.</p> <important>
         *        <p>
         *        If you do not specify a key pair, you can't connect to the instance unless you choose an AMI that is
         *        configured to allow users another way to log in.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in the
         * target Availability Zone, Amazon EC2 launches the largest possible number of instances above
         * <code>MinCount</code>.
         * </p>
         * <p>
         * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         * information about the default limits, and how to request an increase, see <a
         * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I
         * run in Amazon EC2</a> in the Amazon EC2 FAQ.
         * </p>
         * 
         * @param maxCount
         *        The maximum number of instances to launch. If you specify more instances than Amazon EC2 can launch in
         *        the target Availability Zone, Amazon EC2 launches the largest possible number of instances above
         *        <code>MinCount</code>.</p>
         *        <p>
         *        Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         *        information about the default limits, and how to request an increase, see <a
         *        href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances
         *        can I run in Amazon EC2</a> in the Amazon EC2 FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Integer maxCount);

        /**
         * <p>
         * The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon EC2
         * can launch in the target Availability Zone, Amazon EC2 launches no instances.
         * </p>
         * <p>
         * Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         * information about the default limits, and how to request an increase, see <a
         * href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances can I
         * run in Amazon EC2</a> in the Amazon EC2 General FAQ.
         * </p>
         * 
         * @param minCount
         *        The minimum number of instances to launch. If you specify a minimum that is more instances than Amazon
         *        EC2 can launch in the target Availability Zone, Amazon EC2 launches no instances.</p>
         *        <p>
         *        Constraints: Between 1 and the maximum number you're allowed for the specified instance type. For more
         *        information about the default limits, and how to request an increase, see <a
         *        href="http://aws.amazon.com/ec2/faqs/#How_many_instances_can_I_run_in_Amazon_EC2">How many instances
         *        can I run in Amazon EC2</a> in the Amazon EC2 General FAQ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCount(Integer minCount);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Boolean monitoring);

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * 
         * @param placement
         *        The placement for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * The placement for the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link Placement.Builder} avoiding the need to create
         * one manually via {@link Placement#builder()}.
         *
         * When the {@link Consumer} completes, {@link Placement.Builder#build()} is called immediately and its result
         * is passed to {@link #placement(Placement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link Placement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(Placement)
         */
        default Builder placement(Consumer<Placement.Builder> placement) {
            return placement(Placement.builder().apply(placement).build());
        }

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * <important>
         * <p>
         * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * </important>
         * 
         * @param ramdiskId
         *        The ID of the RAM disk.</p> <important>
         *        <p>
         *        We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedkernels.html"> PV-GRUB</a> in the
         *        <i>Amazon Elastic Compute Cloud User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * One or more security group IDs. You can create a security group using <a>CreateSecurityGroup</a>.
         * </p>
         * <p>
         * Default: Amazon EC2 uses the default security group.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security group IDs. You can create a security group using <a>CreateSecurityGroup</a>.</p>
         *        <p>
         *        Default: Amazon EC2 uses the default security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * One or more security group IDs. You can create a security group using <a>CreateSecurityGroup</a>.
         * </p>
         * <p>
         * Default: Amazon EC2 uses the default security group.
         * </p>
         * 
         * @param securityGroupIds
         *        One or more security group IDs. You can create a security group using <a>CreateSecurityGroup</a>.</p>
         *        <p>
         *        Default: Amazon EC2 uses the default security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security
         * group IDs instead.
         * </p>
         * <p>
         * Default: Amazon EC2 uses the default security group.
         * </p>
         * 
         * @param securityGroups
         *        [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use
         *        security group IDs instead.</p>
         *        <p>
         *        Default: Amazon EC2 uses the default security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use security
         * group IDs instead.
         * </p>
         * <p>
         * Default: Amazon EC2 uses the default security group.
         * </p>
         * 
         * @param securityGroups
         *        [EC2-Classic, default VPC] One or more security group names. For a nondefault VPC, you must use
         *        security group IDs instead.</p>
         *        <p>
         *        Default: Amazon EC2 uses the default security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * [EC2-VPC] The ID of the subnet to launch the instance into.
         * </p>
         * 
         * @param subnetId
         *        [EC2-VPC] The ID of the subnet to launch the instance into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The user data to make available to the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your Linux
         * Instance at Launch</a> (Linux) and <a href=
         * "http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
         * >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed for you,
         * and you can load the text from a file. Otherwise, you must provide base64-encoded text.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/user-data.html">Running Commands on Your
         *        Linux Instance at Launch</a> (Linux) and <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html#instancedata-add-user-data"
         *        >Adding User Data</a> (Windows). If you are using a command line tool, base64-encoding is performed
         *        for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param additionalInfo
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more information,
         * see <a href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * <p>
         * Constraints: Maximum 64 ASCII characters
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.</p>
         *        <p>
         *        Constraints: Maximum 64 ASCII characters
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         * console, CLI, or API; otherwise, you can. To change this attribute to <code>false</code> after launch, use
         * <a>ModifyInstanceAttribute</a>. Alternatively, if you set <code>InstanceInitiatedShutdownBehavior</code> to
         * <code>terminate</code>, you can terminate the instance by running the shutdown command from the instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param disableApiTermination
         *        If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         *        console, CLI, or API; otherwise, you can. To change this attribute to <code>false</code> after launch,
         *        use <a>ModifyInstanceAttribute</a>. Alternatively, if you set
         *        <code>InstanceInitiatedShutdownBehavior</code> to <code>terminate</code>, you can terminate the
         *        instance by running the shutdown command from the instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         * throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance.
         * This optimization isn't available with all instance types. Additional usage charges apply when using an
         * EBS-optimized instance.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated
         *        throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O
         *        performance. This optimization isn't available with all instance types. Additional usage charges apply
         *        when using an EBS-optimized instance.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile);

        /**
         * <p>
         * The IAM instance profile.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfileSpecification.Builder}
         * avoiding the need to create one manually via {@link IamInstanceProfileSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfileSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfile(IamInstanceProfileSpecification)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link IamInstanceProfileSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(IamInstanceProfileSpecification)
         */
        default Builder iamInstanceProfile(Consumer<IamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return iamInstanceProfile(IamInstanceProfileSpecification.builder().apply(iamInstanceProfile).build());
        }

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * <p>
         * Default: <code>stop</code>
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).</p>
         *        <p>
         *        Default: <code>stop</code>
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * One or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces);

        /**
         * <p>
         * One or more network interfaces.
         * </p>
         * 
         * @param networkInterfaces
         *        One or more network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces);

        /**
         * <p>
         * [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
         * </p>
         * <p>
         * Only one private IP address can be designated as primary. You can't specify this option if you've specified
         * the option to designate a private IP address as the primary IP address in a network interface specification.
         * You cannot specify this option if you're launching more than one instance in the request.
         * </p>
         * 
         * @param privateIpAddress
         *        [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the
         *        subnet.</p>
         *        <p>
         *        Only one private IP address can be designated as primary. You can't specify this option if you've
         *        specified the option to designate a private IP address as the primary IP address in a network
         *        interface specification. You cannot specify this option if you're launching more than one instance in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * An Elastic GPU to associate with the instance.
         * </p>
         * 
         * @param elasticGpuSpecification
         *        An Elastic GPU to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification);

        /**
         * <p>
         * An Elastic GPU to associate with the instance.
         * </p>
         * 
         * @param elasticGpuSpecification
         *        An Elastic GPU to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecification(ElasticGpuSpecification... elasticGpuSpecification);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can tag instances and volumes. The specified tags are
         * applied to all instances or volumes that are created during launch.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources during launch. You can tag instances and volumes. The specified
         *        tags are applied to all instances or volumes that are created during launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to apply to the resources during launch. You can tag instances and volumes. The specified tags are
         * applied to all instances or volumes that are created during launch.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to apply to the resources during launch. You can tag instances and volumes. The specified
         *        tags are applied to all instances or volumes that are created during launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings;

        private String imageId;

        private String instanceType;

        private Integer ipv6AddressCount;

        private List<InstanceIpv6Address> ipv6Addresses;

        private String kernelId;

        private String keyName;

        private Integer maxCount;

        private Integer minCount;

        private Boolean monitoring;

        private Placement placement;

        private String ramdiskId;

        private List<String> securityGroupIds;

        private List<String> securityGroups;

        private String subnetId;

        private String userData;

        private String additionalInfo;

        private String clientToken;

        private Boolean disableApiTermination;

        private Boolean ebsOptimized;

        private IamInstanceProfileSpecification iamInstanceProfile;

        private String instanceInitiatedShutdownBehavior;

        private List<InstanceNetworkInterfaceSpecification> networkInterfaces;

        private String privateIpAddress;

        private List<ElasticGpuSpecification> elasticGpuSpecification;

        private List<TagSpecification> tagSpecifications;

        private BuilderImpl() {
        }

        private BuilderImpl(RunInstancesRequest model) {
            blockDeviceMappings(model.blockDeviceMappings);
            imageId(model.imageId);
            instanceType(model.instanceType);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            kernelId(model.kernelId);
            keyName(model.keyName);
            maxCount(model.maxCount);
            minCount(model.minCount);
            monitoring(model.monitoring);
            placement(model.placement);
            ramdiskId(model.ramdiskId);
            securityGroupIds(model.securityGroupIds);
            securityGroups(model.securityGroups);
            subnetId(model.subnetId);
            userData(model.userData);
            additionalInfo(model.additionalInfo);
            clientToken(model.clientToken);
            disableApiTermination(model.disableApiTermination);
            ebsOptimized(model.ebsOptimized);
            iamInstanceProfile(model.iamInstanceProfile);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            networkInterfaces(model.networkInterfaces);
            privateIpAddress(model.privateIpAddress);
            elasticGpuSpecification(model.elasticGpuSpecification);
            tagSpecifications(model.tagSpecifications);
        }

        public final Collection<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(BlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<InstanceIpv6Address.Builder> getIpv6Addresses() {
            return ipv6Addresses != null ? ipv6Addresses.stream().map(InstanceIpv6Address::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final Integer getMaxCount() {
            return maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        public final Integer getMinCount() {
            return minCount;
        }

        @Override
        public final Builder minCount(Integer minCount) {
            this.minCount = minCount;
            return this;
        }

        public final void setMinCount(Integer minCount) {
            this.minCount = minCount;
        }

        public final Boolean getMonitoring() {
            return monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final IamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(IamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final Collection<InstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            return networkInterfaces != null ? networkInterfaces.stream().map(InstanceNetworkInterfaceSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(InstanceNetworkInterfaceSpecification... networkInterfaces) {
            networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        public final void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = InstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ElasticGpuSpecification.Builder> getElasticGpuSpecification() {
            return elasticGpuSpecification != null ? elasticGpuSpecification.stream().map(ElasticGpuSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticGpuSpecification(Collection<ElasticGpuSpecification> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copy(elasticGpuSpecification);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecification(ElasticGpuSpecification... elasticGpuSpecification) {
            elasticGpuSpecification(Arrays.asList(elasticGpuSpecification));
            return this;
        }

        public final void setElasticGpuSpecification(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecification) {
            this.elasticGpuSpecification = ElasticGpuSpecificationsCopier.copyFromBuilder(elasticGpuSpecification);
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RunInstancesRequest build() {
            return new RunInstancesRequest(this);
        }
    }
}
