/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network interface for a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstancesNetworkInterface implements
        ToCopyableBuilder<ScheduledInstancesNetworkInterface.Builder, ScheduledInstancesNetworkInterface> {
    private final Boolean associatePublicIpAddress;

    private final Boolean deleteOnTermination;

    private final String description;

    private final Integer deviceIndex;

    private final List<String> groups;

    private final Integer ipv6AddressCount;

    private final List<ScheduledInstancesIpv6Address> ipv6Addresses;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;

    private final Integer secondaryPrivateIpAddressCount;

    private final String subnetId;

    private ScheduledInstancesNetworkInterface(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddressConfigs = builder.privateIpAddressConfigs;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can
     * only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an
     * existing one. You cannot specify more than one network interface in the request. If launching into a default
     * subnet, the default value is <code>true</code>.
     * </p>
     * 
     * @return Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address
     *         can only be assigned to a network interface for eth0, and can only be assigned to a new network
     *         interface, not an existing one. You cannot specify more than one network interface in the request. If
     *         launching into a default subnet, the default value is <code>true</code>.
     */
    public Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Indicates whether to delete the interface when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether to delete the interface when the instance is terminated.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The description.
     * </p>
     * 
     * @return The description.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The index of the device for the network interface attachment.
     * </p>
     * 
     * @return The index of the device for the network interface attachment.
     */
    public Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically selected
     * from the subnet range.
     * </p>
     * 
     * @return The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically
     *         selected from the subnet range.
     */
    public Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * <p>
     * One or more specific IPv6 addresses from the subnet range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more specific IPv6 addresses from the subnet range.
     */
    public List<ScheduledInstancesIpv6Address> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The private IPv4 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The private IPv4 addresses.
     */
    public List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs() {
        return privateIpAddressConfigs;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses.
     */
    public Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddressConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstancesNetworkInterface)) {
            return false;
        }
        ScheduledInstancesNetworkInterface other = (ScheduledInstancesNetworkInterface) obj;
        return Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(description(), other.description()) && Objects.equals(deviceIndex(), other.deviceIndex())
                && Objects.equals(groups(), other.groups()) && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount())
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && Objects.equals(privateIpAddressConfigs(), other.privateIpAddressConfigs())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && Objects.equals(subnetId(), other.subnetId());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduledInstancesNetworkInterface").add("AssociatePublicIpAddress", associatePublicIpAddress())
                .add("DeleteOnTermination", deleteOnTermination()).add("Description", description())
                .add("DeviceIndex", deviceIndex()).add("Groups", groups()).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", ipv6Addresses()).add("NetworkInterfaceId", networkInterfaceId())
                .add("PrivateIpAddress", privateIpAddress()).add("PrivateIpAddressConfigs", privateIpAddressConfigs())
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).add("SubnetId", subnetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatePublicIpAddress":
            return Optional.of(clazz.cast(associatePublicIpAddress()));
        case "DeleteOnTermination":
            return Optional.of(clazz.cast(deleteOnTermination()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DeviceIndex":
            return Optional.of(clazz.cast(deviceIndex()));
        case "Groups":
            return Optional.of(clazz.cast(groups()));
        case "Ipv6AddressCount":
            return Optional.of(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.of(clazz.cast(ipv6Addresses()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddress":
            return Optional.of(clazz.cast(privateIpAddress()));
        case "PrivateIpAddressConfigs":
            return Optional.of(clazz.cast(privateIpAddressConfigs()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.of(clazz.cast(secondaryPrivateIpAddressCount()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstancesNetworkInterface> {
        /**
         * <p>
         * Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4 address can
         * only be assigned to a network interface for eth0, and can only be assigned to a new network interface, not an
         * existing one. You cannot specify more than one network interface in the request. If launching into a default
         * subnet, the default value is <code>true</code>.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Indicates whether to assign a public IPv4 address to instances launched in a VPC. The public IPv4
         *        address can only be assigned to a network interface for eth0, and can only be assigned to a new
         *        network interface, not an existing one. You cannot specify more than one network interface in the
         *        request. If launching into a default subnet, the default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Indicates whether to delete the interface when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether to delete the interface when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The description.
         * </p>
         * 
         * @param description
         *        The description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The index of the device for the network interface attachment.
         * </p>
         * 
         * @param deviceIndex
         *        The index of the device for the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically
         * selected from the subnet range.
         * </p>
         * 
         * @param ipv6AddressCount
         *        The number of IPv6 addresses to assign to the network interface. The IPv6 addresses are automatically
         *        selected from the subnet range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * One or more specific IPv6 addresses from the subnet range.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the subnet range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses);

        /**
         * <p>
         * One or more specific IPv6 addresses from the subnet range.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the subnet range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(ScheduledInstancesIpv6Address... ipv6Addresses);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddressConfigs
         *        The private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs);

        /**
         * <p>
         * The private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddressConfigs
         *        The private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig... privateIpAddressConfigs);

        /**
         * <p>
         * The number of secondary private IPv4 addresses.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean associatePublicIpAddress;

        private Boolean deleteOnTermination;

        private String description;

        private Integer deviceIndex;

        private List<String> groups;

        private Integer ipv6AddressCount;

        private List<ScheduledInstancesIpv6Address> ipv6Addresses;

        private String networkInterfaceId;

        private String privateIpAddress;

        private List<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs;

        private Integer secondaryPrivateIpAddressCount;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstancesNetworkInterface model) {
            associatePublicIpAddress(model.associatePublicIpAddress);
            deleteOnTermination(model.deleteOnTermination);
            description(model.description);
            deviceIndex(model.deviceIndex);
            groups(model.groups);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
            privateIpAddressConfigs(model.privateIpAddressConfigs);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            subnetId(model.subnetId);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final Collection<String> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ScheduledInstancesSecurityGroupIdSetCopier.copy(groups);
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<ScheduledInstancesIpv6Address.Builder> getIpv6Addresses() {
            return ipv6Addresses != null ? ipv6Addresses.stream().map(ScheduledInstancesIpv6Address::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<ScheduledInstancesIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(ScheduledInstancesIpv6Address... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<ScheduledInstancesIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = ScheduledInstancesIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<ScheduledInstancesPrivateIpAddressConfig.Builder> getPrivateIpAddressConfigs() {
            return privateIpAddressConfigs != null ? privateIpAddressConfigs.stream()
                    .map(ScheduledInstancesPrivateIpAddressConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddressConfigs(Collection<ScheduledInstancesPrivateIpAddressConfig> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copy(privateIpAddressConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddressConfigs(ScheduledInstancesPrivateIpAddressConfig... privateIpAddressConfigs) {
            privateIpAddressConfigs(Arrays.asList(privateIpAddressConfigs));
            return this;
        }

        public final void setPrivateIpAddressConfigs(
                Collection<ScheduledInstancesPrivateIpAddressConfig.BuilderImpl> privateIpAddressConfigs) {
            this.privateIpAddressConfigs = PrivateIpAddressConfigSetCopier.copyFromBuilder(privateIpAddressConfigs);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public ScheduledInstancesNetworkInterface build() {
            return new ScheduledInstancesNetworkInterface(this);
        }
    }
}
